/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class VectorReduceSinkOperator
extends ReduceSinkOperator
implements VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private VectorReduceSinkDesc vectorDesc;
    private transient boolean firstBatch;
    private transient VectorExtractRow vectorExtractRow;
    protected transient Object[] singleRow;

    public VectorReduceSinkOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        this(ctx);
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
        this.vContext = vContext;
        this.vectorDesc = (VectorReduceSinkDesc)vectorDesc;
    }

    @VisibleForTesting
    public VectorReduceSinkOperator() {
    }

    public VectorReduceSinkOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        super.initializeOp(hconf);
        this.firstBatch = true;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        if (this.firstBatch) {
            this.vectorExtractRow = new VectorExtractRow();
            this.vectorExtractRow.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
            this.singleRow = new Object[this.vectorExtractRow.getCount()];
            this.firstBatch = false;
        }
        if (batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int logical = 0; logical < batch.size; ++logical) {
                int batchIndex = selected[logical];
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        } else {
            for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                super.process(this.singleRow, tag);
            }
        }
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

