/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CuckooSetBytes;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IStringInExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class StringColumnInList
extends VectorExpression
implements IStringInExpr {
    private static final long serialVersionUID = 1L;
    protected int inputCol;
    private byte[][] inListValues;
    private transient CuckooSetBytes inSet;

    public StringColumnInList() {
    }

    public StringColumnInList(int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.inputCol = colNum;
        this.inSet = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        if (this.inSet == null) {
            this.inSet = new CuckooSetBytes(this.inListValues.length);
            this.inSet.load(this.inListValues);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.inputCol];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] start = inputColVector.start;
        int[] len = inputColVector.length;
        long[] outputVector = outputColVector.vector;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = this.inSet.lookup(vector[0], start[0], len[0]) ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputColVector.isNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputColVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    outputVector[i] = this.inSet.lookup(vector[i], start[i], len[i]) ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public void setInListValues(byte[][] a) {
        this.inListValues = a;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputCol) + ", values " + Arrays.toString((Object[])this.inListValues);
    }
}

