/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import hive.org.apache.parquet.schema.ConversionPatterns;
import hive.org.apache.parquet.schema.GroupType;
import hive.org.apache.parquet.schema.MessageType;
import hive.org.apache.parquet.schema.OriginalType;
import hive.org.apache.parquet.schema.PrimitiveType;
import hive.org.apache.parquet.schema.Type;
import hive.org.apache.parquet.schema.Types;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveSchemaConverter {
    public static MessageType convert(List<String> columnNames, List<TypeInfo> columnTypes) {
        MessageType schema = new MessageType("hive_schema", HiveSchemaConverter.convertTypes(columnNames, columnTypes));
        return schema;
    }

    private static Type[] convertTypes(List<String> columnNames, List<TypeInfo> columnTypes) {
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalStateException("Mismatched Hive columns and types. Hive columns names found : " + columnNames + " . And Hive types found : " + columnTypes);
        }
        Type[] types = new Type[columnNames.size()];
        for (int i = 0; i < columnNames.size(); ++i) {
            types[i] = HiveSchemaConverter.convertType(columnNames.get(i), columnTypes.get(i));
        }
        return types;
    }

    private static Type convertType(String name, TypeInfo typeInfo) {
        return HiveSchemaConverter.convertType(name, typeInfo, Type.Repetition.OPTIONAL);
    }

    private static Type convertType(String name, TypeInfo typeInfo, Type.Repetition repetition) {
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
            if (typeInfo.equals(TypeInfoFactory.stringTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.intTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.shortTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_16)).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.byteTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.INT_8)).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.longTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.doubleTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.floatTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.booleanTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.binaryTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.timestampTypeInfo)) {
                return (Type)Types.primitive(PrimitiveType.PrimitiveTypeName.INT96, repetition).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.voidTypeInfo)) {
                throw new UnsupportedOperationException("Void type not implemented");
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("char")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo.getTypeName().toLowerCase().startsWith("varchar")) {
                return (Type)((Types.PrimitiveBuilder)Types.optional(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named(name);
            }
            if (typeInfo instanceof DecimalTypeInfo) {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                int prec = decimalTypeInfo.precision();
                int scale = decimalTypeInfo.scale();
                int bytes = ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1];
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(bytes)).as(OriginalType.DECIMAL)).scale(scale)).precision(prec)).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.dateTypeInfo)) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(OriginalType.DATE)).named(name);
            }
            if (typeInfo.equals(TypeInfoFactory.unknownTypeInfo)) {
                throw new UnsupportedOperationException("Unknown type not implemented");
            }
            throw new IllegalArgumentException("Unknown type: " + typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            return HiveSchemaConverter.convertArrayType(name, (ListTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return HiveSchemaConverter.convertStructType(name, (StructTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            return HiveSchemaConverter.convertMapType(name, (MapTypeInfo)typeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.UNION)) {
            throw new UnsupportedOperationException("Union type not implemented");
        }
        throw new IllegalArgumentException("Unknown type: " + typeInfo);
    }

    private static GroupType convertArrayType(String name, ListTypeInfo typeInfo) {
        TypeInfo subType = typeInfo.getListElementTypeInfo();
        return new GroupType(Type.Repetition.OPTIONAL, name, OriginalType.LIST, new GroupType(Type.Repetition.REPEATED, ParquetHiveSerDe.ARRAY.toString(), HiveSchemaConverter.convertType("array_element", subType)));
    }

    private static GroupType convertStructType(String name, StructTypeInfo typeInfo) {
        ArrayList<String> columnNames = typeInfo.getAllStructFieldNames();
        ArrayList<TypeInfo> columnTypes = typeInfo.getAllStructFieldTypeInfos();
        return new GroupType(Type.Repetition.OPTIONAL, name, HiveSchemaConverter.convertTypes(columnNames, columnTypes));
    }

    private static GroupType convertMapType(String name, MapTypeInfo typeInfo) {
        Type keyType = HiveSchemaConverter.convertType(ParquetHiveSerDe.MAP_KEY.toString(), typeInfo.getMapKeyTypeInfo(), Type.Repetition.REQUIRED);
        Type valueType = HiveSchemaConverter.convertType(ParquetHiveSerDe.MAP_VALUE.toString(), typeInfo.getMapValueTypeInfo());
        return ConversionPatterns.mapType(Type.Repetition.OPTIONAL, name, keyType, valueType);
    }
}

