/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr.zookeeper;

import hive.com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.hadoop.hive.common.metrics.common.Metrics;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.CuratorFrameworkSingleton;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLock;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperHiveLockManager
implements HiveLockManager {
    HiveLockManagerCtx ctx;
    public static final Logger LOG = LoggerFactory.getLogger((String)"ZooKeeperHiveLockManager");
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    private static CuratorFramework curatorFramework;
    private String parent;
    private long sleepTime;
    private int numRetriesForLock;
    private int numRetriesForUnLock;
    private static String clientIp;
    private static Pattern shMode;
    private static Pattern exMode;

    @Override
    public void setContext(HiveLockManagerCtx ctx) throws LockException {
        this.ctx = ctx;
        HiveConf conf = ctx.getConf();
        this.sleepTime = conf.getTimeVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES, TimeUnit.MILLISECONDS);
        this.numRetriesForLock = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES);
        this.numRetriesForUnLock = conf.getIntVar(HiveConf.ConfVars.HIVE_UNLOCK_NUMRETRIES);
        try {
            curatorFramework = CuratorFrameworkSingleton.getInstance(conf);
            this.parent = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_NAMESPACE);
            try {
                ((ACLBackgroundPathAndBytesable)curatorFramework.create().withMode(CreateMode.PERSISTENT)).forPath("/" + this.parent, new byte[0]);
            }
            catch (Exception e) {
                if (!(e instanceof KeeperException) || ((KeeperException)e).code() != KeeperException.Code.NODEEXISTS) {
                    LOG.warn("Unexpected ZK exception when creating parent node /" + this.parent, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to create curatorFramework object: ", (Throwable)e);
            throw new LockException(ErrorMsg.ZOOKEEPER_CLIENT_COULD_NOT_BE_INITIALIZED.getMsg());
        }
    }

    @Override
    public void refresh() {
        HiveConf conf = this.ctx.getConf();
        this.sleepTime = conf.getTimeVar(HiveConf.ConfVars.HIVE_LOCK_SLEEP_BETWEEN_RETRIES, TimeUnit.MILLISECONDS);
        this.numRetriesForLock = conf.getIntVar(HiveConf.ConfVars.HIVE_LOCK_NUMRETRIES);
        this.numRetriesForUnLock = conf.getIntVar(HiveConf.ConfVars.HIVE_UNLOCK_NUMRETRIES);
    }

    private static String getLastObjectName(String parent, HiveLockObject key) {
        return "/" + parent + "/" + key.getName();
    }

    private List<String> getObjectNames(HiveLockObject key) {
        String[] names;
        ArrayList<String> parents = new ArrayList<String>();
        String curParent = "/" + this.parent + "/";
        for (String name : names = key.getName().split("/")) {
            curParent = curParent + name;
            parents.add(curParent);
            curParent = curParent + "/";
        }
        return parents;
    }

    @Override
    public List<HiveLock> lock(List<HiveLockObj> lockObjects, boolean keepAlive, Driver.LockedDriverState lDrvState) throws LockException {
        Collections.sort(lockObjects, new Comparator<HiveLockObj>(){

            @Override
            public int compare(HiveLockObj o1, HiveLockObj o2) {
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp == 0) {
                    if (o1.getMode() == o2.getMode()) {
                        return cmp;
                    }
                    if (o1.getMode() == HiveLockMode.EXCLUSIVE) {
                        return -1;
                    }
                    return 1;
                }
                return cmp;
            }
        });
        HiveLockObj prevLockObj = null;
        ArrayList<HiveLock> hiveLocks = new ArrayList<HiveLock>();
        for (HiveLockObj lockObject : lockObjects) {
            if (prevLockObj != null && prevLockObj.getName().equals(lockObject.getName())) {
                prevLockObj = lockObject;
                continue;
            }
            ZooKeeperHiveLock lock2 = null;
            boolean isInterrupted = false;
            if (lDrvState != null) {
                lDrvState.stateLock.lock();
                if (lDrvState.isAborted()) {
                    isInterrupted = true;
                }
                lDrvState.stateLock.unlock();
            }
            if (!isInterrupted) {
                try {
                    lock2 = this.lock(lockObject.getObj(), lockObject.getMode(), keepAlive, true);
                }
                catch (LockException e) {
                    console.printError("Error in acquireLocks...");
                    LOG.error("Error in acquireLocks...", (Throwable)e);
                    lock2 = null;
                }
            }
            if (lock2 == null) {
                this.releaseLocks(hiveLocks);
                if (isInterrupted) {
                    throw new LockException(ErrorMsg.LOCK_ACQUIRE_CANCELLED.getMsg());
                }
                return null;
            }
            hiveLocks.add(lock2);
            prevLockObj = lockObject;
        }
        return hiveLocks;
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) {
        if (hiveLocks != null) {
            int len = hiveLocks.size();
            for (int pos = len - 1; pos >= 0; --pos) {
                HiveLock hiveLock = hiveLocks.get(pos);
                try {
                    LOG.debug("About to release lock for {}", (Object)hiveLock.getHiveLockObject().getName());
                    this.unlock(hiveLock);
                    continue;
                }
                catch (LockException e) {
                    LOG.warn("Error when releasing lock", (Throwable)e);
                }
            }
        }
    }

    @Override
    public ZooKeeperHiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive) throws LockException {
        return this.lock(key, mode, keepAlive, false);
    }

    private String createChild(String name, byte[] data, CreateMode mode) throws Exception {
        return (String)((ACLBackgroundPathAndBytesable)curatorFramework.create().withMode(mode)).forPath(name, data);
    }

    private String getLockName(String parent, HiveLockMode mode) {
        return parent + "/LOCK-" + (Object)((Object)mode) + "-";
    }

    private ZooKeeperHiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive, boolean parentCreated) throws LockException {
        LOG.debug("Acquiring lock for {} with mode {} {}", new Object[]{key.getName(), mode, key.getData().getLockMode()});
        int tryNum = 0;
        ZooKeeperHiveLock ret = null;
        HashSet<String> conflictingLocks = new HashSet<String>();
        Exception lastException = null;
        do {
            lastException = null;
            ++tryNum;
            try {
                if (tryNum > 1) {
                    Thread.sleep(this.sleepTime);
                    this.prepareRetry();
                }
                if ((ret = this.lockPrimitive(key, mode, keepAlive, parentCreated, conflictingLocks)) == null) continue;
                break;
            }
            catch (Exception e1) {
                lastException = e1;
                if (e1 instanceof KeeperException) {
                    KeeperException e = (KeeperException)e1;
                    switch (e.code()) {
                        case CONNECTIONLOSS: 
                        case OPERATIONTIMEOUT: 
                        case NONODE: 
                        case NODEEXISTS: {
                            LOG.debug("Possibly transient ZooKeeper exception: ", (Throwable)e);
                            break;
                        }
                        default: {
                            LOG.error("Serious Zookeeper exception: ", (Throwable)e);
                            break;
                        }
                    }
                    continue;
                }
                LOG.error("Other unexpected exception: ", (Throwable)e1);
            }
        } while (tryNum < this.numRetriesForLock);
        if (ret == null) {
            console.printError("Unable to acquire " + key.getData().getLockMode() + ", " + (Object)((Object)mode) + " lock " + key.getDisplayName() + " after " + tryNum + " attempts.");
            this.printConflictingLocks(key, mode, conflictingLocks);
            if (lastException != null) {
                LOG.error("Exceeds maximum retries with errors: ", (Throwable)lastException);
                throw new LockException(lastException);
            }
        }
        return ret;
    }

    private void printConflictingLocks(HiveLockObject key, HiveLockMode mode, Set<String> conflictingLocks) {
        if (!conflictingLocks.isEmpty()) {
            HiveLockObject.HiveLockObjectData requestedLock = new HiveLockObject.HiveLockObjectData(key.getData().toString());
            LOG.debug("Requested lock " + key.getDisplayName() + ":: mode:" + requestedLock.getLockMode() + "," + (Object)((Object)mode) + "; query:" + requestedLock.getQueryStr());
            for (String conflictingLock : conflictingLocks) {
                HiveLockObject.HiveLockObjectData conflictingLockData = new HiveLockObject.HiveLockObjectData(conflictingLock);
                LOG.debug("Conflicting lock to " + key.getDisplayName() + ":: mode:" + conflictingLockData.getLockMode() + ";query:" + conflictingLockData.getQueryStr() + ";queryId:" + conflictingLockData.getQueryId() + ";clientIp:" + conflictingLockData.getClientIp());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeperHiveLock lockPrimitive(HiveLockObject key, HiveLockMode mode, boolean keepAlive, boolean parentCreated, Set<String> conflictingLocks) throws Exception {
        String res;
        String lastName;
        List<Object> names = new ArrayList();
        HiveLockObject.HiveLockObjectData lockData = key.getData();
        lockData.setClientIp(clientIp);
        if (parentCreated) {
            lastName = ZooKeeperHiveLockManager.getLastObjectName(this.parent, key);
            names.add(lastName);
        } else {
            names = this.getObjectNames(key);
            lastName = (String)names.get(names.size() - 1);
        }
        for (String string : names) {
            try {
                res = this.createChild(string, new byte[0], CreateMode.PERSISTENT);
            }
            catch (Exception e) {
                if (e instanceof KeeperException && ((KeeperException)e).code() == KeeperException.Code.NODEEXISTS) continue;
                throw e;
            }
        }
        res = this.createChild(this.getLockName(lastName, mode), key.getData().toString().getBytes(), keepAlive ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL);
        int seqNo = this.getSequenceNumber(res, this.getLockName(lastName, mode));
        if (seqNo == -1) {
            curatorFramework.delete().forPath(res);
            throw new LockException("The created node does not contain a sequence number: " + res);
        }
        List list = (List)curatorFramework.getChildren().forPath(lastName);
        String exLock = this.getLockName(lastName, HiveLockMode.EXCLUSIVE);
        String shLock = this.getLockName(lastName, HiveLockMode.SHARED);
        for (String child : list) {
            child = lastName + "/" + child;
            int childSeq = seqNo;
            if (child.startsWith(exLock)) {
                childSeq = this.getSequenceNumber(child, exLock);
            }
            if (mode == HiveLockMode.EXCLUSIVE && child.startsWith(shLock)) {
                childSeq = this.getSequenceNumber(child, shLock);
            }
            if (childSeq < 0 || childSeq >= seqNo) continue;
            try {
                curatorFramework.delete().forPath(res);
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    try {
                        String data = new String((byte[])curatorFramework.getData().forPath(child));
                        conflictingLocks.add(data);
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        }
        Metrics metrics = MetricsFactory.getInstance();
        if (metrics != null) {
            try {
                switch (mode) {
                    case EXCLUSIVE: {
                        metrics.incrementCounter("zookeeper_hive_exclusivelocks");
                        break;
                    }
                    case SEMI_SHARED: {
                        metrics.incrementCounter("zookeeper_hive_semisharedlocks");
                        break;
                    }
                    default: {
                        metrics.incrementCounter("zookeeper_hive_sharedlocks");
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Error Reporting hive client zookeeper lock operation to Metrics system", (Throwable)e);
            }
        }
        return new ZooKeeperHiveLock(res, key, mode);
    }

    @Override
    public void unlock(HiveLock hiveLock) throws LockException {
        this.unlockWithRetry(hiveLock, this.parent);
    }

    private void unlockWithRetry(HiveLock hiveLock, String parent) throws LockException {
        int tryNum = 0;
        while (true) {
            try {
                if (++tryNum > 1) {
                    Thread.sleep(this.sleepTime);
                }
                ZooKeeperHiveLockManager.unlockPrimitive(hiveLock, parent, curatorFramework);
            }
            catch (Exception e) {
                if (tryNum < this.numRetriesForUnLock) continue;
                String name = ((ZooKeeperHiveLock)hiveLock).getPath();
                LOG.error("Node " + name + " can not be deleted after " + this.numRetriesForUnLock + " attempts.");
                throw new LockException(e);
                if (tryNum < this.numRetriesForUnLock) continue;
            }
            break;
        }
    }

    @VisibleForTesting
    static void unlockPrimitive(HiveLock hiveLock, String parent, CuratorFramework curatorFramework) throws LockException {
        ZooKeeperHiveLock zLock = (ZooKeeperHiveLock)hiveLock;
        HiveLockMode lMode = hiveLock.getHiveLockMode();
        HiveLockObject obj = zLock.getHiveLockObject();
        String name = ZooKeeperHiveLockManager.getLastObjectName(parent, obj);
        try {
            Metrics metrics;
            try {
                curatorFramework.delete().forPath(zLock.getPath());
            }
            catch (InterruptedException ie) {
                curatorFramework.delete().forPath(zLock.getPath());
            }
            List children = null;
            try {
                children = (List)curatorFramework.getChildren().forPath(name);
            }
            catch (InterruptedException ie) {
                children = (List)curatorFramework.getChildren().forPath(name);
            }
            if (children == null || children.isEmpty()) {
                try {
                    curatorFramework.delete().forPath(name);
                }
                catch (InterruptedException ie) {
                    curatorFramework.delete().forPath(name);
                }
            }
            if ((metrics = MetricsFactory.getInstance()) != null) {
                try {
                    switch (lMode) {
                        case EXCLUSIVE: {
                            metrics.decrementCounter("zookeeper_hive_exclusivelocks");
                            break;
                        }
                        case SEMI_SHARED: {
                            metrics.decrementCounter("zookeeper_hive_semisharedlocks");
                            break;
                        }
                        default: {
                            metrics.decrementCounter("zookeeper_hive_sharedlocks");
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error Reporting hive client zookeeper unlock operation to Metrics system", (Throwable)e);
                }
            }
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.debug("Node " + zLock.getPath() + " or its parent has already been deleted.");
        }
        catch (KeeperException.NotEmptyException nee) {
            LOG.debug("Node " + name + " to be deleted is not empty.");
        }
        catch (Exception e) {
            LOG.error("Failed to release ZooKeeper lock: ", (Throwable)e);
            throw new LockException(e);
        }
    }

    public static void releaseAllLocks(HiveConf conf) throws Exception {
        try {
            String parent = conf.getVar(HiveConf.ConfVars.HIVE_ZOOKEEPER_NAMESPACE);
            List<HiveLock> locks = ZooKeeperHiveLockManager.getLocks(conf, null, parent, false, false);
            Exception lastExceptionGot = null;
            if (locks != null) {
                for (HiveLock lock2 : locks) {
                    try {
                        ZooKeeperHiveLockManager.unlockPrimitive(lock2, parent, curatorFramework);
                    }
                    catch (Exception e) {
                        lastExceptionGot = e;
                    }
                }
            }
            if (lastExceptionGot != null) {
                throw lastExceptionGot;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to release all locks: ", (Throwable)e);
            throw new Exception(ErrorMsg.ZOOKEEPER_CLIENT_COULD_NOT_BE_INITIALIZED.getMsg());
        }
    }

    @Override
    public List<HiveLock> getLocks(boolean verifyTablePartition, boolean fetchData) throws LockException {
        return ZooKeeperHiveLockManager.getLocks(this.ctx.getConf(), null, this.parent, verifyTablePartition, fetchData);
    }

    @Override
    public List<HiveLock> getLocks(HiveLockObject key, boolean verifyTablePartitions, boolean fetchData) throws LockException {
        return ZooKeeperHiveLockManager.getLocks(this.ctx.getConf(), key, this.parent, verifyTablePartitions, fetchData);
    }

    private static List<HiveLock> getLocks(HiveConf conf, HiveLockObject key, String parent, boolean verifyTablePartition, boolean fetchData) throws LockException {
        List children;
        String commonParent;
        ArrayList<HiveLock> locks = new ArrayList<HiveLock>();
        boolean recurse = true;
        try {
            if (key != null) {
                commonParent = "/" + parent + "/" + key.getName();
                children = (List)curatorFramework.getChildren().forPath(commonParent);
                recurse = false;
            } else {
                commonParent = "/" + parent;
                children = (List)curatorFramework.getChildren().forPath(commonParent);
            }
        }
        catch (Exception e) {
            return locks;
        }
        LinkedList<String> childn = new LinkedList<String>();
        if (children != null && !children.isEmpty()) {
            for (Object child : children) {
                childn.add(commonParent + "/" + (String)child);
            }
        }
        String curChild;
        while ((curChild = (String)childn.poll()) != null) {
            HiveLockObject.HiveLockObjectData data;
            HiveLockObject obj;
            HiveLockMode mode;
            if (recurse) {
                try {
                    children = (List)curatorFramework.getChildren().forPath(curChild);
                    for (String child : children) {
                        childn.add(curChild + "/" + child);
                    }
                }
                catch (Exception child) {
                    // empty catch block
                }
            }
            if ((mode = ZooKeeperHiveLockManager.getLockMode(curChild)) == null || (obj = ZooKeeperHiveLockManager.getLockObject(conf, curChild, mode, data = null, parent, verifyTablePartition)) == null || key != null && !obj.getName().equals(key.getName())) continue;
            if (fetchData) {
                try {
                    data = new HiveLockObject.HiveLockObjectData(new String((byte[])((BackgroundPathable)curatorFramework.getData().watched()).forPath(curChild)));
                    data.setClientIp(clientIp);
                }
                catch (Exception e) {
                    LOG.error("Error in getting data for " + curChild, (Throwable)e);
                }
            }
            obj.setData(data);
            ZooKeeperHiveLock lck = new ZooKeeperHiveLock(curChild, obj, mode);
            locks.add(lck);
        }
        return locks;
    }

    private void removeAllRedundantNodes() {
        try {
            this.checkRedundantNode("/" + this.parent);
        }
        catch (Exception e) {
            LOG.warn("Exception while removing all redundant nodes", (Throwable)e);
        }
    }

    private void checkRedundantNode(String node) {
        try {
            if (ZooKeeperHiveLockManager.getLockMode(node) != null) {
                return;
            }
            List children = (List)curatorFramework.getChildren().forPath(node);
            for (String child : children) {
                this.checkRedundantNode(node + "/" + child);
            }
            children = (List)curatorFramework.getChildren().forPath(node);
            if (children == null || children.isEmpty()) {
                curatorFramework.delete().forPath(node);
            }
        }
        catch (Exception e) {
            LOG.warn("Error in checkRedundantNode for node " + node, (Throwable)e);
        }
    }

    @Override
    public void close() throws LockException {
        try {
            if (HiveConf.getBoolVar(this.ctx.getConf(), HiveConf.ConfVars.HIVE_ZOOKEEPER_CLEAN_EXTRA_NODES)) {
                this.removeAllRedundantNodes();
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close zooKeeper client: " + e);
            throw new LockException(e);
        }
    }

    private int getSequenceNumber(String resPath, String path) {
        String tst = resPath.substring(path.length());
        try {
            return new Integer(tst);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static HiveLockObject getLockObject(HiveConf conf, String path, HiveLockMode mode, HiveLockObject.HiveLockObjectData data, String parent, boolean verifyTablePartition) throws LockException {
        try {
            Partition partn;
            Hive db = Hive.get(conf);
            int indx = path.lastIndexOf("LOCK-" + mode.toString());
            String objName = path.substring(("/" + parent + "/").length(), indx - 1);
            String[] names = objName.split("/");
            if (names.length < 2) {
                return null;
            }
            if (!verifyTablePartition) {
                return new HiveLockObject(names, data);
            }
            Table tab = db.getTable(names[0], names[1], false);
            if (tab == null) {
                return null;
            }
            if (names.length == 2) {
                return new HiveLockObject(tab, data);
            }
            HashMap<String, String> partSpec = new HashMap<String, String>();
            for (indx = 2; indx < names.length; ++indx) {
                String[] partVals = names[indx].split("=");
                partSpec.put(partVals[0], partVals[1]);
            }
            try {
                partn = db.getPartition(tab, partSpec, false);
            }
            catch (HiveException e) {
                partn = null;
            }
            if (partn == null) {
                return new HiveLockObject(new DummyPartition(tab, path, partSpec), data);
            }
            return new HiveLockObject(partn, data);
        }
        catch (Exception e) {
            LOG.error("Failed to create ZooKeeper object: " + e);
            throw new LockException(e);
        }
    }

    private static HiveLockMode getLockMode(String path) {
        Matcher shMatcher = shMode.matcher(path);
        Matcher exMatcher = exMode.matcher(path);
        if (shMatcher.matches()) {
            return HiveLockMode.SHARED;
        }
        if (exMatcher.matches()) {
            return HiveLockMode.EXCLUSIVE;
        }
        return null;
    }

    @Override
    public void prepareRetry() throws LockException {
    }

    static {
        clientIp = "UNKNOWN";
        try {
            InetAddress clientAddr = InetAddress.getLocalHost();
            clientIp = clientAddr.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        shMode = Pattern.compile("^.*-(SHARED)-([0-9]+)$");
        exMode = Pattern.compile("^.*-(EXCLUSIVE)-([0-9]+)$");
    }
}

