/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import hive.com.fasterxml.jackson.annotation.JsonIdentityInfo;
import hive.com.fasterxml.jackson.annotation.JsonProperty;
import hive.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import hive.com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.optimizer.signature.SignatureUtils;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
public final class OpSignature {
    @JsonProperty
    private Map<String, Object> sigMap;

    private OpSignature() {
    }

    private OpSignature(Operator<? extends OperatorDesc> op) {
        this.sigMap = new HashMap<String, Object>();
        SignatureUtils.write(this.sigMap, op.getConf());
    }

    public static OpSignature of(Operator<? extends OperatorDesc> op) {
        return new OpSignature(op);
    }

    public int hashCode() {
        return this.sigMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OpSignature)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        OpSignature o = (OpSignature)obj;
        return this.signatureCompare(o);
    }

    public boolean signatureCompare(OpSignature other) {
        return this.sigMap.equals(other.sigMap);
    }

    @VisibleForTesting
    public void proveEquals(OpSignature other) {
        OpSignature.proveEquals(this.sigMap, other.sigMap);
    }

    private static void proveEquals(Map<String, Object> m1, Map<String, Object> m2) {
        for (Map.Entry<String, Object> e : m1.entrySet()) {
            Object v2;
            String key = e.getKey();
            Object v1 = e.getValue();
            if (v1 == (v2 = m2.get(key)) || v1 != null && v2 != null && v1.equals(v2)) continue;
            throw new RuntimeException(String.format("equals fails: %s (%s!=%s)", key, v1, v2));
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String pad) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> e : this.sigMap.entrySet()) {
            sb.append(pad);
            sb.append(e.getKey());
            sb.append(" = ");
            sb.append(e.getValue());
            sb.append('\n');
        }
        return sb.toString();
    }

    public Map<String, Object> getSigMap() {
        return this.sigMap;
    }
}

