/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import hive.com.google.common.base.Preconditions;
import hive.org.apache.commons.codec.digest.DigestUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.hive.llap.LlapInputSplit;
import org.apache.hadoop.hive.llap.NotTezEventHelper;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.llap.SubmitWorkInfo;
import org.apache.hadoop.hive.llap.coordinator.LlapCoordinator;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.LlapTokenLocalClient;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.HiveSplitGenerator;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TaskSpecBuilder;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="get_splits", value="_FUNC_(string,int) - Returns an array of length int serialized splits for the referenced tables string. Passing length 0 returns only schema data for the compiled query.")
@UDFType(deterministic=false)
public class GenericUDTFGetSplits
extends GenericUDTF {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDTFGetSplits.class);
    protected transient StringObjectInspector stringOI;
    protected transient IntObjectInspector intOI;
    protected transient JobConf jc;
    private boolean orderByQuery;
    private boolean forceSingleSplit;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
    private DataOutput dos = new DataOutputStream(this.bos);

    @Override
    public StructObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        LOG.debug("initializing GenericUDFGetSplits");
        if (SessionState.get() == null || SessionState.get().getConf() == null) {
            throw new IllegalStateException("Cannot run get splits outside HS2");
        }
        LOG.debug("Initialized conf, jc and metastore connection");
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function GET_SPLITS accepts 2 arguments.");
        }
        if (!(arguments[0] instanceof StringObjectInspector)) {
            LOG.error("Got " + arguments[0].getTypeName() + " instead of string.");
            throw new UDFArgumentTypeException(0, "\"string\" is expected at function GET_SPLITS, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        if (!(arguments[1] instanceof IntObjectInspector)) {
            LOG.error("Got " + arguments[1].getTypeName() + " instead of int.");
            throw new UDFArgumentTypeException(1, "\"int\" is expected at function GET_SPLITS, but \"" + arguments[1].getTypeName() + "\" is found");
        }
        this.stringOI = (StringObjectInspector)arguments[0];
        this.intOI = (IntObjectInspector)arguments[1];
        List<String> names = Arrays.asList("split");
        List<ObjectInspector> fieldOIs = Arrays.asList(PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector);
        StandardStructObjectInspector outputOI = ObjectInspectorFactory.getStandardStructObjectInspector(names, fieldOIs);
        LOG.debug("done initializing GenericUDFGetSplits");
        return outputOI;
    }

    @Override
    public void process(Object[] arguments) throws HiveException {
        String query = this.stringOI.getPrimitiveJavaObject(arguments[0]);
        int num = this.intOI.get(arguments[1]);
        LlapCoordinator coordinator = LlapCoordinator.getInstance();
        if (coordinator == null) {
            throw new HiveException("LLAP coordinator is not initialized; must be running in HS2 with " + HiveConf.ConfVars.LLAP_HS2_ENABLE_COORDINATOR.varname + " enabled");
        }
        ApplicationId applicationId = coordinator.createExtClientAppId();
        LOG.info("Generated appID {} for LLAP splits", (Object)applicationId.toString());
        PlanFragment fragment = this.createPlanFragment(query, num, applicationId);
        TezWork tezWork = fragment.work;
        Schema schema = fragment.schema;
        boolean generateSingleSplit = this.forceSingleSplit && this.orderByQuery;
        try {
            InputSplit[] splits = this.getSplits(this.jc, num, tezWork, schema, applicationId, generateSingleSplit);
            LOG.info("Generated {} splits for query {}. orderByQuery: {} forceSingleSplit: {}", new Object[]{splits.length, query, this.orderByQuery, this.forceSingleSplit});
            if (generateSingleSplit && splits.length > 1) {
                throw new HiveException("Got more than one split (Got: " + splits.length + ") for order by query: " + query);
            }
            for (InputSplit s : splits) {
                Object[] os = new Object[1];
                this.bos.reset();
                s.write(this.dos);
                byte[] frozen = this.bos.toByteArray();
                os[0] = frozen;
                this.forward(os);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlanFragment createPlanFragment(String query, int num, ApplicationId splitsAppId) throws HiveException {
        HiveConf conf = new HiveConf(SessionState.get().getConf());
        HiveConf.setVar(conf, HiveConf.ConfVars.HIVEFETCHTASKCONVERSION, "none");
        HiveConf.setVar(conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT, "Llap");
        String originalMode = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE);
        HiveConf.setVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE, "llap");
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS, true);
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS, true);
        conf.setBoolean("tez.grouping.node.local.only", true);
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, true);
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED, false);
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_REMOVE_ORDERBY_IN_SUBQUERY, false);
        try {
            this.jc = DagUtils.getInstance().createConfiguration(conf);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        HiveTxnManager txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        Driver driver = new Driver(new QueryState.Builder().withHiveConf(conf).nonIsolated().build(), null, null, txnManager);
        DriverCleanup driverCleanup = new DriverCleanup(driver, txnManager, splitsAppId.toString());
        boolean needsCleanup = true;
        try {
            String validWriteIdString;
            TezWork tezWork;
            boolean fetchTask;
            CommandProcessorResponse cpr = driver.compileAndRespond(query, false);
            if (cpr.getResponseCode() != 0) {
                throw new HiveException("Failed to compile query: " + cpr.getException());
            }
            QueryPlan plan = driver.getPlan();
            this.orderByQuery = plan.getQueryProperties().hasOrderBy() || plan.getQueryProperties().hasOuterOrderBy();
            this.forceSingleSplit = this.orderByQuery && HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_EXTERNAL_SPLITS_ORDER_BY_FORCE_SINGLE_SPLIT);
            ArrayList<Task<? extends Serializable>> roots = plan.getRootTasks();
            Schema schema = this.convertSchema(plan.getResultSchema());
            if (num == 0) {
                PlanFragment planFragment = new PlanFragment(null, schema, null);
                return planFragment;
            }
            boolean bl = fetchTask = plan.getFetchTask() != null;
            if (roots == null || roots.size() != 1 || !(roots.get(0) instanceof TezTask)) {
                if (!fetchTask) throw new HiveException("Was expecting a single TezTask or FetchTask.");
                tezWork = null;
            } else {
                tezWork = (TezWork)((TezTask)roots.get(0)).getWork();
            }
            if (tezWork == null || tezWork.getAllWork().size() != 1) {
                String tableName = "table_" + UUID.randomUUID().toString().replaceAll("[^A-Za-z0-9 ]", "");
                String storageFormatString = this.getTempTableStorageFormatString(conf);
                String ctas = "create temporary table " + tableName + " " + storageFormatString + " as " + query;
                LOG.info("Materializing the query for LLAPIF; CTAS: " + ctas);
                driver.releaseLocksAndCommitOrRollback(false);
                driver.releaseResources();
                HiveConf.setVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE, originalMode);
                cpr = driver.run(ctas, false);
                if (cpr.getResponseCode() != 0) {
                    throw new HiveException("Failed to create temp table: " + cpr.getException());
                }
                HiveConf.setVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_MODE, "llap");
                query = "select * from " + tableName;
                cpr = driver.compileAndRespond(query, true);
                if (cpr.getResponseCode() != 0) {
                    throw new HiveException("Failed to create temp table: " + cpr.getException());
                }
                plan = driver.getPlan();
                roots = plan.getRootTasks();
                schema = this.convertSchema(plan.getResultSchema());
                if (roots == null || roots.size() != 1 || !(roots.get(0) instanceof TezTask)) {
                    throw new HiveException("Was expecting a single TezTask.");
                }
                tezWork = (TezWork)((TezTask)roots.get(0)).getWork();
            } else {
                try {
                    driver.lockAndRespond();
                }
                catch (CommandProcessorResponse cpr1) {
                    throw new HiveException("Failed to acquire locks", cpr1);
                }
                SessionState.get().addCleanupItem(driverCleanup);
                needsCleanup = false;
            }
            HiveConf driverConf = driver.getConf();
            String validTxnString = driverConf.get("hive.txn.valid.txns");
            if (validTxnString != null) {
                this.jc.set("hive.txn.valid.txns", validTxnString);
            }
            if ((validWriteIdString = driverConf.get("hive.txn.tables.valid.writeids")) != null) {
                assert (validTxnString != null);
                this.jc.set("hive.txn.tables.valid.writeids", validWriteIdString);
            }
            PlanFragment planFragment = new PlanFragment(tezWork, schema, this.jc);
            return planFragment;
        }
        finally {
            if (needsCleanup) {
                if (driverCleanup != null) {
                    try {
                        driverCleanup.close();
                    }
                    catch (IOException err) {
                        throw new HiveException(err);
                    }
                } else if (driver != null) {
                    driver.close();
                    driver.destroy();
                }
            }
        }
    }

    public InputSplit[] getSplits(JobConf job, int numSplits, TezWork work, Schema schema, ApplicationId applicationId, boolean generateSingleSplit) throws IOException {
        if (numSplits == 0) {
            LlapInputSplit schemaSplit = new LlapInputSplit(0, new byte[0], new byte[0], new byte[0], new SplitLocationInfo[0], schema, "", new byte[0]);
            return new InputSplit[]{schemaSplit};
        }
        DAG dag = DAG.create((String)work.getName());
        dag.setCredentials(job.getCredentials());
        DagUtils utils = DagUtils.getInstance();
        Context ctx = new Context((Configuration)job);
        MapWork mapWork = (MapWork)work.getAllWork().get(0);
        JobConf wxConf = utils.initializeVertexConf(job, ctx, (BaseWork)mapWork);
        Path scratchDir = utils.createTezDir(ctx.getMRScratchDir(), (Configuration)job);
        FileSystem fs = scratchDir.getFileSystem((Configuration)job);
        try {
            LocalResource appJarLr = this.createJarLocalResource(utils.getExecJarPathLocal(ctx.getConf()), utils, (Configuration)job);
            LlapCoordinator coordinator = LlapCoordinator.getInstance();
            if (coordinator == null) {
                throw new IOException("LLAP coordinator is not initialized; must be running in HS2 with " + HiveConf.ConfVars.LLAP_HS2_ENABLE_COORDINATOR.varname + " enabled");
            }
            HiveConf.setVar((Configuration)wxConf, HiveConf.ConfVars.HIVEQUERYID, applicationId.toString());
            Vertex wx = utils.createVertex(wxConf, mapWork, scratchDir, fs, ctx, false, work, work.getVertexType(mapWork), DagUtils.createTezLrMap(appJarLr, null));
            String vertexName = wx.getName();
            dag.addVertex(wx);
            utils.addCredentials((BaseWork)mapWork, dag);
            Preconditions.checkState(HiveConf.getBoolVar((Configuration)wxConf, HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS));
            Preconditions.checkState(HiveConf.getBoolVar((Configuration)wxConf, HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS));
            HiveSplitGenerator splitGenerator = new HiveSplitGenerator((Configuration)wxConf, mapWork, generateSingleSplit);
            List<Event> eventList = splitGenerator.initialize();
            InputSplit[] result = new InputSplit[eventList.size() - 1];
            InputConfigureVertexTasksEvent configureEvent = (InputConfigureVertexTasksEvent)eventList.get(0);
            List hints = configureEvent.getLocationHint().getTaskLocationHints();
            Preconditions.checkState(hints.size() == eventList.size() - 1);
            if (LOG.isDebugEnabled()) {
                LOG.debug("NumEvents=" + eventList.size() + ", NumSplits=" + result.length);
            }
            String llapUser = UserGroupInformation.getLoginUser().getShortUserName();
            String queryUser = null;
            byte[] tokenBytes = null;
            LlapSigner signer = null;
            if (UserGroupInformation.isSecurityEnabled()) {
                signer = coordinator.getLlapSigner((Configuration)job);
                queryUser = SessionState.getUserFromAuthenticator();
                if (queryUser == null) {
                    queryUser = UserGroupInformation.getCurrentUser().getUserName();
                    LOG.warn("Cannot determine the session user; using " + queryUser + " instead");
                }
                LlapTokenLocalClient tokenClient = coordinator.getLocalTokenClient((Configuration)job, llapUser);
                Token<LlapTokenIdentifier> token = tokenClient.createToken(applicationId.toString(), queryUser, true);
                LOG.info("Created the token for remote user: {}", token);
                this.bos.reset();
                token.write(this.dos);
                tokenBytes = this.bos.toByteArray();
            } else {
                queryUser = UserGroupInformation.getCurrentUser().getUserName();
            }
            Token umbilicalToken = JobTokenCreator.createJobToken(applicationId);
            LOG.info("Number of splits: " + (eventList.size() - 1));
            LlapSigner.SignedMessage signedSvs = null;
            for (int i = 0; i < eventList.size() - 1; ++i) {
                TaskSpec taskSpec = new TaskSpecBuilder().constructTaskSpec(dag, vertexName, eventList.size() - 1, applicationId, i);
                if (i == 0) {
                    signedSvs = this.createSignedVertexSpec(signer, taskSpec, applicationId, queryUser, applicationId.toString());
                }
                SubmitWorkInfo submitWorkInfo = new SubmitWorkInfo(applicationId, System.currentTimeMillis(), taskSpec.getVertexParallelism(), signedSvs.message, signedSvs.signature, (Token<JobTokenIdentifier>)umbilicalToken);
                byte[] submitWorkBytes = SubmitWorkInfo.toBytes(submitWorkInfo);
                LlapSigner.SignedMessage eventBytes = this.makeEventBytes(wx, vertexName, eventList.get(i + 1), signer);
                SplitLocationInfo[] locations = this.makeLocationHints((TaskLocationHint)hints.get(i));
                result[i] = new LlapInputSplit(i, submitWorkBytes, eventBytes.message, eventBytes.signature, locations, schema, llapUser, tokenBytes);
            }
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private SplitLocationInfo[] makeLocationHints(TaskLocationHint hint) {
        Set hosts = hint.getHosts();
        if (hosts == null) {
            LOG.warn("No hosts");
            return new SplitLocationInfo[0];
        }
        if (hosts.size() != 1) {
            LOG.warn("Bad # of locations: " + hosts.size());
        }
        SplitLocationInfo[] locations = new SplitLocationInfo[hosts.size()];
        int j = 0;
        for (String host : hosts) {
            locations[j++] = new SplitLocationInfo(host, false);
        }
        return locations;
    }

    private LlapSigner.SignedMessage makeEventBytes(Vertex wx, String vertexName, Event event, LlapSigner signer) throws IOException {
        assert (event instanceof InputDataInformationEvent);
        List<RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> inputs = TaskSpecBuilder.getVertexInputs(wx);
        Preconditions.checkState(inputs.size() == 1);
        LlapSigner.Signable signableNte = NotTezEventHelper.createSignableNotTezEvent((InputDataInformationEvent)event, vertexName, inputs.get(0).getName());
        if (signer != null) {
            return signer.serializeAndSign(signableNte);
        }
        LlapSigner.SignedMessage sm = new LlapSigner.SignedMessage();
        sm.message = signableNte.serialize();
        return sm;
    }

    private LlapSigner.SignedMessage createSignedVertexSpec(LlapSigner signer, TaskSpec taskSpec, ApplicationId applicationId, String queryUser, String queryIdString) throws IOException {
        LlapDaemonProtocolProtos.QueryIdentifierProto queryIdentifierProto = LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString(applicationId.toString()).setDagIndex(taskSpec.getDagIdentifier()).setAppAttemptNumber(0).build();
        final LlapDaemonProtocolProtos.SignableVertexSpec.Builder svsb = Converters.constructSignableVertexSpec(taskSpec, queryIdentifierProto, applicationId.toString(), queryUser, queryIdString);
        svsb.setIsExternalSubmission(true);
        if (signer == null) {
            LlapSigner.SignedMessage result = new LlapSigner.SignedMessage();
            result.message = GenericUDTFGetSplits.serializeVertexSpec(svsb);
            return result;
        }
        return signer.serializeAndSign(new LlapSigner.Signable(){

            @Override
            public void setSignInfo(int masterKeyId) {
                svsb.setSignatureKeyId(masterKeyId);
            }

            @Override
            public byte[] serialize() throws IOException {
                return GenericUDTFGetSplits.serializeVertexSpec(svsb);
            }
        });
    }

    private static byte[] serializeVertexSpec(LlapDaemonProtocolProtos.SignableVertexSpec.Builder svsb) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        svsb.build().writeTo(os);
        return os.toByteArray();
    }

    private LocalResource createJarLocalResource(String localJarPath, DagUtils utils, Configuration conf) throws IOException, LoginException, IllegalArgumentException, FileNotFoundException {
        FileStatus destDirStatus = utils.getHiveJarDirectory(conf);
        assert (destDirStatus != null);
        Path destDirPath = destDirStatus.getPath();
        Path localFile = new Path(localJarPath);
        String sha = this.getSha(localFile, conf);
        String destFileName = localFile.getName();
        destFileName = FilenameUtils.removeExtension((String)destFileName) + "-" + sha + '.' + FilenameUtils.getExtension((String)destFileName);
        Path destFile = new Path(destDirPath.toString() + "/" + destFileName);
        return utils.localizeResource(localFile, destFile, LocalResourceType.FILE, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSha(Path localFile, Configuration conf) throws IOException, IllegalArgumentException {
        try (InputStream is = null;){
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
            is = localFs.open(localFile);
            String string = DigestUtils.sha256Hex(is);
            return string;
        }
    }

    private Schema convertSchema(Object obj) throws HiveException {
        org.apache.hadoop.hive.metastore.api.Schema schema = (org.apache.hadoop.hive.metastore.api.Schema)obj;
        ArrayList<FieldDesc> colDescs = new ArrayList<FieldDesc>();
        for (FieldSchema fs : schema.getFieldSchemas()) {
            String colName = fs.getName();
            String typeString = fs.getType();
            colDescs.add(new FieldDesc(colName, TypeInfoUtils.getTypeInfoFromTypeString(typeString)));
        }
        Schema Schema2 = new Schema(colDescs);
        return Schema2;
    }

    private String getTempTableStorageFormatString(HiveConf conf) {
        String formatString = "";
        String storageFormatOption = conf.getVar(HiveConf.ConfVars.LLAP_EXTERNAL_SPLITS_TEMP_TABLE_STORAGE_FORMAT).toLowerCase();
        if (storageFormatOption.equals("text")) {
            formatString = "stored as textfile";
        } else if (storageFormatOption.equals("orc")) {
            formatString = "stored as orc";
        }
        return formatString;
    }

    @Override
    public void close() throws HiveException {
    }

    private static class JobTokenCreator {
        private JobTokenCreator() {
        }

        private static Token<JobTokenIdentifier> createJobToken(ApplicationId applicationId) {
            String tokenIdentifier = applicationId.toString();
            JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(tokenIdentifier));
            Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)new JobTokenSecretManager());
            sessionToken.setService(identifier.getJobId());
            return sessionToken;
        }
    }

    private static class DriverCleanup
    implements Closeable {
        private final Driver driver;
        private final HiveTxnManager txnManager;
        private final String applicationId;

        public DriverCleanup(Driver driver, HiveTxnManager txnManager, String applicationId) {
            this.driver = driver;
            this.txnManager = txnManager;
            this.applicationId = applicationId;
        }

        @Override
        public void close() throws IOException {
            try {
                LOG.info("DriverCleanup for LLAP splits: {}", (Object)this.applicationId);
                this.driver.releaseLocksAndCommitOrRollback(true);
                this.driver.close();
                this.driver.destroy();
                this.txnManager.closeTxnManager();
            }
            catch (Exception err) {
                LOG.error("Error closing driver resources", (Throwable)err);
                throw new IOException(err);
            }
        }

        public String toString() {
            return "DriverCleanup for LLAP splits: " + this.applicationId;
        }
    }

    public static class PlanFragment {
        public JobConf jc;
        public TezWork work;
        public Schema schema;

        public PlanFragment(TezWork work, Schema schema, JobConf jc) {
            this.work = work;
            this.schema = schema;
            this.jc = jc;
        }
    }
}

