/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.fast;

import hive.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.lazy.LazyBinary;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyShort;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.fast.StringToDouble;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.TimestampParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LazySimpleDeserializeRead
extends DeserializeRead {
    public static final Logger LOG = LoggerFactory.getLogger((String)LazySimpleDeserializeRead.class.getName());
    private int[] startPositions;
    private final byte[] separators;
    private final boolean isEscaped;
    private final byte escapeChar;
    private final int[] escapeCounts;
    private final byte[] nullSequenceBytes;
    private final boolean isExtendedBooleanLiteral;
    private final int fieldCount;
    private final Field[] fields;
    private final int maxLevelDepth;
    private byte[] bytes;
    private int start;
    private int end;
    private boolean topLevelParsed;
    private int nextFieldIndex;
    private int currentLevel;
    private int currentTopLevelFieldIndex;
    private int currentFieldStart;
    private int currentFieldLength;
    private int currentEscapeCount;
    private ComplexTypeHelper[] currentComplexTypeHelpers;
    private int internalBufferLen;
    private byte[] internalBuffer;
    private final TimestampParser timestampParser;
    private boolean isEndOfInputReached;
    private static final byte[] maxLongBytes = Long.valueOf(Long.MAX_VALUE).toString().getBytes();

    private int addComplexFields(List<TypeInfo> fieldTypeInfoList, Field[] fields, int depth) {
        int count = fieldTypeInfoList.size();
        for (int i = 0; i < count; ++i) {
            Field field = new Field(fieldTypeInfoList.get(i));
            if (!field.isPrimitive) {
                depth = Math.max(depth, this.addComplexTypeHelper(field, depth));
            }
            fields[i] = field;
        }
        return depth;
    }

    private int addComplexTypeHelper(Field complexField, int depth) {
        ++depth;
        switch (complexField.complexCategory) {
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)complexField.typeInfo;
                Field elementField = new Field(listTypeInfo.getListElementTypeInfo());
                if (!elementField.isPrimitive) {
                    depth = this.addComplexTypeHelper(elementField, depth);
                }
                ListComplexTypeHelper listHelper = new ListComplexTypeHelper(complexField, elementField);
                complexField.complexTypeHelper = listHelper;
                break;
            }
            case MAP: {
                ++depth;
                MapTypeInfo mapTypeInfo = (MapTypeInfo)complexField.typeInfo;
                Field keyField = new Field(mapTypeInfo.getMapKeyTypeInfo());
                if (!keyField.isPrimitive) {
                    depth = Math.max(depth, this.addComplexTypeHelper(keyField, depth));
                }
                Field valueField = new Field(mapTypeInfo.getMapValueTypeInfo());
                if (!valueField.isPrimitive) {
                    depth = Math.max(depth, this.addComplexTypeHelper(valueField, depth));
                }
                MapComplexTypeHelper mapHelper = new MapComplexTypeHelper(complexField, keyField, valueField);
                complexField.complexTypeHelper = mapHelper;
                break;
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)complexField.typeInfo;
                ArrayList<TypeInfo> fieldTypeInfoList = structTypeInfo.getAllStructFieldTypeInfos();
                Field[] fields = new Field[fieldTypeInfoList.size()];
                depth = this.addComplexFields(fieldTypeInfoList, fields, depth);
                StructComplexTypeHelper structHelper = new StructComplexTypeHelper(complexField, fields);
                complexField.complexTypeHelper = structHelper;
                break;
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)complexField.typeInfo;
                List<TypeInfo> fieldTypeInfoList = unionTypeInfo.getAllUnionObjectTypeInfos();
                Field[] fields = new Field[fieldTypeInfoList.size()];
                depth = this.addComplexFields(fieldTypeInfoList, fields, depth);
                UnionComplexTypeHelper structHelper = new UnionComplexTypeHelper(complexField, fields);
                complexField.complexTypeHelper = structHelper;
                break;
            }
            default: {
                throw new Error("Unexpected complex category " + (Object)((Object)complexField.complexCategory));
            }
        }
        return depth;
    }

    public LazySimpleDeserializeRead(TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, boolean useExternalBuffer, LazySerDeParameters lazyParams) {
        super(typeInfos, dataTypePhysicalVariations, useExternalBuffer);
        int count;
        this.fieldCount = count = typeInfos.length;
        int depth = 0;
        this.fields = new Field[count];
        for (int i = 0; i < count; ++i) {
            Field field = new Field(typeInfos[i], this.dataTypePhysicalVariations[i]);
            if (!field.isPrimitive) {
                depth = Math.max(depth, this.addComplexTypeHelper(field, 0));
            }
            this.fields[i] = field;
        }
        this.maxLevelDepth = depth;
        this.currentComplexTypeHelpers = new ComplexTypeHelper[depth];
        this.startPositions = new int[count + 1];
        this.separators = lazyParams.getSeparators();
        this.isEscaped = lazyParams.isEscaped();
        if (this.isEscaped) {
            this.escapeChar = lazyParams.getEscapeChar();
            this.escapeCounts = new int[count];
        } else {
            this.escapeChar = 0;
            this.escapeCounts = null;
        }
        this.nullSequenceBytes = lazyParams.getNullSequence().getBytes();
        this.isExtendedBooleanLiteral = lazyParams.isExtendedBooleanLiteral();
        if (lazyParams.isLastColumnTakesRest()) {
            throw new RuntimeException("serialization.last.column.takes.rest not supported");
        }
        this.timestampParser = new TimestampParser();
        this.internalBufferLen = -1;
    }

    public LazySimpleDeserializeRead(TypeInfo[] typeInfos, boolean useExternalBuffer, LazySerDeParameters lazyParams) {
        this(typeInfos, null, useExternalBuffer, lazyParams);
    }

    @Override
    public void set(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.start = offset;
        this.end = offset + length;
        this.topLevelParsed = false;
        this.currentLevel = 0;
        this.nextFieldIndex = -1;
    }

    @Override
    public String getDetailedReadPositionString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Reading byte[] of length ");
        sb.append(this.bytes.length);
        sb.append(" at start offset ");
        sb.append(this.start);
        sb.append(" for length ");
        sb.append(this.end - this.start);
        sb.append(" to read ");
        sb.append(this.fieldCount);
        sb.append(" fields with types ");
        sb.append(Arrays.toString(this.typeInfos));
        sb.append(".  ");
        if (!this.topLevelParsed) {
            sb.append("Error during field separator parsing");
        } else {
            sb.append("Read field #");
            sb.append(this.currentTopLevelFieldIndex);
            sb.append(" at field start position ");
            sb.append(this.startPositions[this.currentTopLevelFieldIndex]);
            int currentFieldLength = this.startPositions[this.currentTopLevelFieldIndex + 1] - this.startPositions[this.currentTopLevelFieldIndex] - 1;
            sb.append(" for field length ");
            sb.append(currentFieldLength);
        }
        return sb.toString();
    }

    private void topLevelParse() {
        int fieldId = 0;
        int fieldByteBegin = this.start;
        int fieldByteEnd = this.start;
        byte separator = this.separators[0];
        int fieldCount = this.fieldCount;
        int[] startPositions = this.startPositions;
        byte[] bytes = this.bytes;
        int end = this.end;
        if (!this.isEscaped) {
            while (fieldByteEnd < end) {
                if (bytes[fieldByteEnd] == separator) {
                    startPositions[fieldId++] = fieldByteBegin;
                    if (fieldId == fieldCount) break;
                    fieldByteBegin = ++fieldByteEnd;
                    continue;
                }
                ++fieldByteEnd;
            }
            if (fieldByteEnd == end && fieldId < fieldCount) {
                startPositions[fieldId++] = fieldByteBegin;
            }
        } else {
            byte escapeChar = this.escapeChar;
            int endLessOne = end - 1;
            int[] escapeCounts = this.escapeCounts;
            int escapeCount = 0;
            while (fieldByteEnd < endLessOne) {
                if (bytes[fieldByteEnd] == separator) {
                    escapeCounts[fieldId] = escapeCount;
                    escapeCount = 0;
                    startPositions[fieldId++] = fieldByteBegin;
                    if (fieldId == fieldCount) break;
                    fieldByteBegin = ++fieldByteEnd;
                    continue;
                }
                if (bytes[fieldByteEnd] == escapeChar) {
                    fieldByteEnd += 2;
                    ++escapeCount;
                    continue;
                }
                ++fieldByteEnd;
            }
            if (fieldByteEnd == endLessOne && fieldId < fieldCount) {
                if (bytes[fieldByteEnd] == separator) {
                    escapeCounts[fieldId] = escapeCount;
                    escapeCount = 0;
                    startPositions[fieldId++] = fieldByteBegin;
                    if (fieldId <= fieldCount) {
                        fieldByteBegin = ++fieldByteEnd;
                    }
                } else {
                    ++fieldByteEnd;
                }
            }
            if (fieldByteEnd == end && fieldId < fieldCount) {
                escapeCounts[fieldId] = escapeCount;
                startPositions[fieldId++] = fieldByteBegin;
            }
        }
        if (fieldId == fieldCount || fieldByteEnd == end) {
            Arrays.fill(startPositions, fieldId, startPositions.length, fieldByteEnd + 1);
        }
        this.isEndOfInputReached = fieldByteEnd == end;
    }

    private int parseComplexField(int start, int end, int level) {
        int fieldByteEnd;
        if (start == end + 1) {
            return start - 1;
        }
        byte separator = this.separators[level];
        byte[] bytes = this.bytes;
        this.currentEscapeCount = 0;
        if (!this.isEscaped) {
            for (fieldByteEnd = start; fieldByteEnd < end; ++fieldByteEnd) {
                if (bytes[fieldByteEnd] != separator) continue;
                return fieldByteEnd;
            }
        } else {
            byte escapeChar = this.escapeChar;
            int endLessOne = end - 1;
            int escapeCount = 0;
            while (fieldByteEnd < endLessOne) {
                if (bytes[fieldByteEnd] == separator) {
                    this.currentEscapeCount = escapeCount;
                    return fieldByteEnd;
                }
                if (bytes[fieldByteEnd] == escapeChar) {
                    fieldByteEnd += 2;
                    ++escapeCount;
                    continue;
                }
                ++fieldByteEnd;
            }
            if (fieldByteEnd == endLessOne && bytes[fieldByteEnd] != separator) {
                ++fieldByteEnd;
            }
            this.currentEscapeCount = escapeCount;
        }
        return fieldByteEnd;
    }

    @Override
    public boolean readNextField() throws IOException {
        if (this.nextFieldIndex + 1 >= this.fieldCount) {
            return false;
        }
        ++this.nextFieldIndex;
        return this.readField(this.nextFieldIndex);
    }

    @Override
    public void skipNextField() throws IOException {
        if (!this.topLevelParsed) {
            this.topLevelParse();
            this.topLevelParsed = true;
        }
        if (this.nextFieldIndex + 1 < this.fieldCount) {
            ++this.nextFieldIndex;
        }
    }

    @Override
    public boolean isReadFieldSupported() {
        return true;
    }

    private boolean checkNull(byte[] bytes, int start, int len) {
        if (len != this.nullSequenceBytes.length) {
            return false;
        }
        byte[] nullSequenceBytes = this.nullSequenceBytes;
        switch (len) {
            case 0: {
                return true;
            }
            case 2: {
                return bytes[start] == nullSequenceBytes[0] && bytes[start + 1] == nullSequenceBytes[1];
            }
            case 4: {
                return bytes[start] == nullSequenceBytes[0] && bytes[start + 1] == nullSequenceBytes[1] && bytes[start + 2] == nullSequenceBytes[2] && bytes[start + 3] == nullSequenceBytes[3];
            }
        }
        for (int i = 0; i < nullSequenceBytes.length; ++i) {
            if (bytes[start + i] == nullSequenceBytes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean readField(int fieldIndex) throws IOException {
        Preconditions.checkState(this.currentLevel == 0);
        if (!this.topLevelParsed) {
            this.topLevelParse();
            this.topLevelParsed = true;
        }
        this.currentTopLevelFieldIndex = fieldIndex;
        this.currentFieldStart = this.startPositions[fieldIndex];
        this.currentFieldLength = this.startPositions[fieldIndex + 1] - this.startPositions[fieldIndex] - 1;
        this.currentEscapeCount = this.isEscaped ? this.escapeCounts[fieldIndex] : 0;
        return this.doReadField(this.fields[fieldIndex]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doReadField(Field field) {
        int fieldStart = this.currentFieldStart;
        int fieldLength = this.currentFieldLength;
        if (fieldLength < 0) {
            return false;
        }
        byte[] bytes = this.bytes;
        if (this.nullSequenceBytes != null && this.checkNull(bytes, fieldStart, fieldLength)) {
            return false;
        }
        try {
            if (field.isPrimitive) {
                switch (field.primitiveCategory) {
                    case BOOLEAN: {
                        int i = fieldStart;
                        if (fieldLength == 4) {
                            if (bytes[i] != 84 && bytes[i] != 116 || bytes[i + 1] != 82 && bytes[i + 1] != 114 || bytes[i + 2] != 85 && bytes[i + 2] != 117 || bytes[i + 3] != 69 && bytes[i + 3] != 101) return false;
                            this.currentBoolean = true;
                            return true;
                        } else if (fieldLength == 5) {
                            if (bytes[i] != 70 && bytes[i] != 102 || bytes[i + 1] != 65 && bytes[i + 1] != 97 || bytes[i + 2] != 76 && bytes[i + 2] != 108 || bytes[i + 3] != 83 && bytes[i + 3] != 115 || bytes[i + 4] != 69 && bytes[i + 4] != 101) return false;
                            this.currentBoolean = false;
                            return true;
                        } else {
                            if (!this.isExtendedBooleanLiteral || fieldLength != 1) return false;
                            byte b = bytes[fieldStart];
                            if (b == 49 || b == 116 || b == 84) {
                                this.currentBoolean = true;
                                return true;
                            } else {
                                if (b != 48 && b != 102 && b != 70) return false;
                                this.currentBoolean = false;
                            }
                        }
                        return true;
                    }
                    case BYTE: {
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentByte = LazyByte.parseByte(bytes, fieldStart, fieldLength, 10);
                        return true;
                    }
                    case SHORT: {
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentShort = LazyShort.parseShort(bytes, fieldStart, fieldLength, 10);
                        return true;
                    }
                    case INT: {
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentInt = LazyInteger.parseInt(bytes, fieldStart, fieldLength, 10);
                        return true;
                    }
                    case LONG: {
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentLong = LazyLong.parseLong(bytes, fieldStart, fieldLength, 10);
                        return true;
                    }
                    case FLOAT: {
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentFloat = Float.parseFloat(new String(bytes, fieldStart, fieldLength, StandardCharsets.UTF_8));
                        return true;
                    }
                    case DOUBLE: {
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentDouble = StringToDouble.strtod(bytes, fieldStart, fieldLength);
                        return true;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        if (this.isEscaped) {
                            if (this.currentEscapeCount == 0) {
                                this.currentExternalBufferNeeded = false;
                                this.currentBytes = bytes;
                                this.currentBytesStart = fieldStart;
                                this.currentBytesLength = fieldLength;
                                return true;
                            } else {
                                int unescapedLength = fieldLength - this.currentEscapeCount;
                                if (this.useExternalBuffer) {
                                    this.currentExternalBufferNeeded = true;
                                    this.currentExternalBufferNeededLen = unescapedLength;
                                    return true;
                                } else {
                                    this.currentExternalBufferNeeded = false;
                                    if (this.internalBufferLen < unescapedLength) {
                                        this.internalBufferLen = unescapedLength;
                                        this.internalBuffer = new byte[this.internalBufferLen];
                                    }
                                    this.copyToBuffer(this.internalBuffer, 0, unescapedLength);
                                    this.currentBytes = this.internalBuffer;
                                    this.currentBytesStart = 0;
                                    this.currentBytesLength = unescapedLength;
                                }
                            }
                            return true;
                        } else {
                            this.currentExternalBufferNeeded = false;
                            this.currentBytes = bytes;
                            this.currentBytesStart = fieldStart;
                            this.currentBytesLength = fieldLength;
                        }
                        return true;
                    }
                    case BINARY: {
                        byte[] recv = new byte[fieldLength];
                        System.arraycopy(bytes, fieldStart, recv, 0, fieldLength);
                        byte[] decoded = LazyBinary.decodeIfNeeded(recv);
                        decoded = decoded.length > 0 ? decoded : recv;
                        this.currentBytes = decoded;
                        this.currentBytesStart = 0;
                        this.currentBytesLength = decoded.length;
                        return true;
                    }
                    case DATE: {
                        if (!LazyUtils.isDateMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentDateWritable.set(Date.valueOf(new String(bytes, fieldStart, fieldLength, StandardCharsets.UTF_8)));
                        return true;
                    }
                    case TIMESTAMP: {
                        if (!LazyUtils.isDateMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        String s = new String(bytes, fieldStart, fieldLength, StandardCharsets.US_ASCII);
                        if (s.compareTo("NULL") == 0) {
                            this.logExceptionMessage(bytes, fieldStart, fieldLength, "TIMESTAMP");
                            return false;
                        }
                        try {
                            this.currentTimestampWritable.set(this.timestampParser.parseTimestamp(s));
                            return true;
                        }
                        catch (IllegalArgumentException e) {
                            this.logExceptionMessage(bytes, fieldStart, fieldLength, "TIMESTAMP");
                            return false;
                        }
                    }
                    case INTERVAL_YEAR_MONTH: {
                        if (fieldLength == 0) {
                            return false;
                        }
                        try {
                            String s = new String(bytes, fieldStart, fieldLength, StandardCharsets.UTF_8);
                            this.currentHiveIntervalYearMonthWritable.set(HiveIntervalYearMonth.valueOf(s));
                            return true;
                        }
                        catch (Exception e) {
                            this.logExceptionMessage(bytes, fieldStart, fieldLength, "INTERVAL_YEAR_MONTH");
                            return false;
                        }
                    }
                    case INTERVAL_DAY_TIME: {
                        if (fieldLength == 0) {
                            return false;
                        }
                        try {
                            String s = new String(bytes, fieldStart, fieldLength, StandardCharsets.UTF_8);
                            this.currentHiveIntervalDayTimeWritable.set(HiveIntervalDayTime.valueOf(s));
                            return true;
                        }
                        catch (Exception e) {
                            this.logExceptionMessage(bytes, fieldStart, fieldLength, "INTERVAL_DAY_TIME");
                            return false;
                        }
                    }
                    case DECIMAL: {
                        boolean decimalIsNull;
                        if (!LazyUtils.isNumberMaybe(bytes, fieldStart, fieldLength)) {
                            return false;
                        }
                        this.currentHiveDecimalWritable.setFromBytes(bytes, fieldStart, fieldLength, true);
                        boolean bl = decimalIsNull = !this.currentHiveDecimalWritable.isSet();
                        if (!decimalIsNull) {
                            int scale;
                            DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)field.typeInfo;
                            int precision = decimalTypeInfo.getPrecision();
                            boolean bl2 = decimalIsNull = !this.currentHiveDecimalWritable.mutateEnforcePrecisionScale(precision, scale = decimalTypeInfo.getScale());
                            if (!decimalIsNull) {
                                if (field.dataTypePhysicalVariation != DataTypePhysicalVariation.DECIMAL_64) return true;
                                this.currentDecimal64 = this.currentHiveDecimalWritable.serialize64(scale);
                                return true;
                            }
                        }
                        if (!LOG.isDebugEnabled()) return false;
                        LOG.debug("Data not in the HiveDecimal data type range so converted to null. Given data is :" + new String(bytes, fieldStart, fieldLength, StandardCharsets.UTF_8));
                        return false;
                    }
                }
                throw new Error("Unexpected primitive category " + (Object)((Object)field.primitiveCategory));
            }
            switch (field.complexCategory) {
                case LIST: 
                case MAP: 
                case STRUCT: 
                case UNION: {
                    if (this.currentLevel > 0 && this.currentComplexTypeHelpers[this.currentLevel - 1] == null) {
                        Preconditions.checkState(this.currentLevel > 1);
                        Preconditions.checkState(this.currentComplexTypeHelpers[this.currentLevel - 2] instanceof MapComplexTypeHelper);
                        ++this.currentLevel;
                    }
                    ComplexTypeHelper complexTypeHelper = field.complexTypeHelper;
                    this.currentComplexTypeHelpers[this.currentLevel++] = complexTypeHelper;
                    if (field.complexCategory == ObjectInspector.Category.MAP) {
                        this.currentComplexTypeHelpers[this.currentLevel] = null;
                    }
                    complexTypeHelper.setCurrentFieldInfo(this.currentFieldStart, this.currentFieldLength);
                    return true;
                }
            }
            throw new Error("Unexpected complex category " + (Object)((Object)field.complexCategory));
        }
        catch (NumberFormatException nfe) {
            this.logExceptionMessage(bytes, fieldStart, fieldLength, field.complexCategory, field.primitiveCategory);
            return false;
        }
        catch (IllegalArgumentException iae) {
            this.logExceptionMessage(bytes, fieldStart, fieldLength, field.complexCategory, field.primitiveCategory);
            return false;
        }
    }

    @Override
    public void copyToExternalBuffer(byte[] externalBuffer, int externalBufferStart) {
        this.copyToBuffer(externalBuffer, externalBufferStart, this.currentExternalBufferNeededLen);
    }

    private void copyToBuffer(byte[] buffer, int bufferStart, int bufferLength) {
        int fieldStart = this.currentFieldStart;
        int fieldLength = this.currentFieldLength;
        int k = 0;
        for (int i = 0; i < fieldLength; ++i) {
            byte b = this.bytes[fieldStart + i];
            if (b == this.escapeChar && i < fieldLength - 1) {
                if (this.bytes[fieldStart + ++i] == 114) {
                    buffer[bufferStart + k++] = 13;
                    continue;
                }
                if (this.bytes[fieldStart + i] == 110) {
                    buffer[bufferStart + k++] = 10;
                    continue;
                }
                buffer[bufferStart + k++] = this.bytes[fieldStart + i];
                continue;
            }
            buffer[bufferStart + k++] = b;
        }
    }

    @Override
    public boolean isNextComplexMultiValue() {
        Preconditions.checkState(this.currentLevel > 0);
        ComplexTypeHelper complexTypeHelper = this.currentComplexTypeHelpers[this.currentLevel - 1];
        Field complexField = complexTypeHelper.complexField;
        int fieldPosition = complexTypeHelper.fieldPosition;
        int complexFieldEnd = complexTypeHelper.complexFieldEnd;
        switch (complexField.complexCategory) {
            case LIST: {
                boolean isNext;
                boolean bl = isNext = fieldPosition <= complexFieldEnd;
                if (!isNext) {
                    this.popComplexType();
                }
                return isNext;
            }
            case MAP: {
                boolean isNext;
                boolean bl = isNext = fieldPosition < complexFieldEnd;
                if (!isNext) {
                    this.popComplexType();
                }
                return isNext;
            }
            case STRUCT: 
            case UNION: {
                throw new Error("Complex category " + (Object)((Object)complexField.complexCategory) + " not multi-value");
            }
        }
        throw new Error("Unexpected complex category " + (Object)((Object)complexField.complexCategory));
    }

    private void popComplexType() {
        Preconditions.checkState(this.currentLevel > 0);
        --this.currentLevel;
        if (this.currentLevel > 0 && this.currentComplexTypeHelpers[this.currentLevel - 1] == null) {
            Preconditions.checkState(this.currentLevel > 1);
            Preconditions.checkState(this.currentComplexTypeHelpers[this.currentLevel - 2] instanceof MapComplexTypeHelper);
            --this.currentLevel;
        }
    }

    @Override
    public boolean readComplexField() throws IOException {
        Preconditions.checkState(this.currentLevel > 0);
        ComplexTypeHelper complexTypeHelper = this.currentComplexTypeHelpers[this.currentLevel - 1];
        Field complexField = complexTypeHelper.complexField;
        switch (complexField.complexCategory) {
            case LIST: {
                ListComplexTypeHelper listHelper = (ListComplexTypeHelper)complexTypeHelper;
                int fieldPosition = listHelper.fieldPosition;
                int complexFieldEnd = listHelper.complexFieldEnd;
                Preconditions.checkState(fieldPosition <= complexFieldEnd + 1);
                int fieldEnd = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel);
                listHelper.fieldPosition = fieldEnd + 1;
                this.currentFieldStart = fieldPosition;
                this.currentFieldLength = fieldEnd - fieldPosition;
                return this.doReadField(listHelper.elementField);
            }
            case MAP: {
                MapComplexTypeHelper mapHelper = (MapComplexTypeHelper)complexTypeHelper;
                int fieldPosition = mapHelper.fieldPosition;
                int complexFieldEnd = mapHelper.complexFieldEnd;
                Preconditions.checkState(fieldPosition <= complexFieldEnd + 1);
                this.currentFieldStart = fieldPosition;
                boolean isParentMap = this.isParentMap();
                if (isParentMap) {
                    ++this.currentLevel;
                }
                if (!mapHelper.fieldHaveParsedKey) {
                    int fieldEnd = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel + 1);
                    mapHelper.fieldPosition = fieldEnd + 1;
                    this.currentFieldLength = fieldEnd - fieldPosition;
                    mapHelper.fieldHaveParsedKey = true;
                    boolean result = this.doReadField(mapHelper.keyField);
                    if (isParentMap) {
                        --this.currentLevel;
                    }
                    return result;
                }
                int fieldEnd = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel);
                mapHelper.fieldPosition = fieldEnd + 1;
                this.currentFieldLength = fieldEnd - fieldPosition;
                mapHelper.fieldHaveParsedKey = false;
                boolean result = this.doReadField(mapHelper.valueField);
                if (isParentMap) {
                    --this.currentLevel;
                }
                return result;
            }
            case STRUCT: {
                StructComplexTypeHelper structHelper = (StructComplexTypeHelper)complexTypeHelper;
                int fieldPosition = structHelper.fieldPosition;
                int complexFieldEnd = structHelper.complexFieldEnd;
                Preconditions.checkState(fieldPosition <= complexFieldEnd + 1);
                this.currentFieldStart = fieldPosition;
                int nextFieldIndex = structHelper.nextFieldIndex;
                Field[] fields = structHelper.fields;
                if (nextFieldIndex != fields.length - 1) {
                    int fieldEnd = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel);
                    structHelper.fieldPosition = fieldEnd + 1;
                    this.currentFieldLength = fieldEnd - fieldPosition;
                    return this.doReadField(fields[structHelper.nextFieldIndex++]);
                }
                int fieldEnd = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel);
                this.currentFieldLength = fieldEnd - fieldPosition;
                structHelper.nextFieldIndex = 0;
                boolean result = this.doReadField(fields[fields.length - 1]);
                if (!this.isEscaped) {
                    structHelper.fieldPosition = complexFieldEnd + 1;
                    this.currentEscapeCount = 0;
                } else {
                    this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel - 1);
                }
                return result;
            }
            case UNION: {
                UnionComplexTypeHelper unionHelper = (UnionComplexTypeHelper)complexTypeHelper;
                int fieldPosition = unionHelper.fieldPosition;
                int complexFieldEnd = unionHelper.complexFieldEnd;
                Preconditions.checkState(fieldPosition <= complexFieldEnd + 1);
                this.currentFieldStart = fieldPosition;
                if (!unionHelper.fieldHaveParsedTag) {
                    boolean isParentMap = this.isParentMap();
                    if (isParentMap) {
                        ++this.currentLevel;
                    }
                    int fieldEnd = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel);
                    unionHelper.fieldPosition = fieldEnd + 1;
                    this.currentFieldLength = fieldEnd - fieldPosition;
                    unionHelper.fieldHaveParsedTag = true;
                    boolean successful = this.doReadField(unionHelper.tagField);
                    if (!successful) {
                        throw new IOException("Null union tag");
                    }
                    unionHelper.fieldTag = this.currentInt;
                    if (isParentMap) {
                        --this.currentLevel;
                    }
                    return true;
                }
                if (!this.isEscaped) {
                    unionHelper.fieldPosition = complexFieldEnd + 1;
                    this.currentEscapeCount = 0;
                } else {
                    int n = this.parseComplexField(fieldPosition, complexFieldEnd, this.currentLevel - 1);
                }
                this.currentFieldLength = complexFieldEnd - fieldPosition;
                unionHelper.fieldHaveParsedTag = false;
                return this.doReadField(unionHelper.fields[unionHelper.fieldTag]);
            }
        }
        throw new Error("Unexpected complex category " + (Object)((Object)complexField.complexCategory));
    }

    private boolean isParentMap() {
        return this.currentLevel >= 2 && this.currentComplexTypeHelpers[this.currentLevel - 2] instanceof MapComplexTypeHelper;
    }

    @Override
    public void finishComplexVariableFieldsType() {
        Preconditions.checkState(this.currentLevel > 0);
        ComplexTypeHelper complexTypeHelper = this.currentComplexTypeHelpers[this.currentLevel - 1];
        Field complexField = complexTypeHelper.complexField;
        switch (complexField.complexCategory) {
            case LIST: 
            case MAP: {
                throw new Error("Complex category " + (Object)((Object)complexField.complexCategory) + " is not variable fields type");
            }
            case STRUCT: 
            case UNION: {
                this.popComplexType();
                break;
            }
            default: {
                throw new Error("Unexpected category " + (Object)((Object)complexField.complexCategory));
            }
        }
    }

    @Override
    public boolean isEndOfInputReached() {
        return this.isEndOfInputReached;
    }

    public void logExceptionMessage(byte[] bytes, int bytesStart, int bytesLength, ObjectInspector.Category dataComplexCategory, PrimitiveObjectInspector.PrimitiveCategory dataPrimitiveCategory) {
        String dataType;
        if (dataComplexCategory == null) {
            switch (dataPrimitiveCategory) {
                case BYTE: {
                    dataType = "TINYINT";
                    break;
                }
                case LONG: {
                    dataType = "BIGINT";
                    break;
                }
                case SHORT: {
                    dataType = "SMALLINT";
                    break;
                }
                default: {
                    dataType = dataPrimitiveCategory.toString();
                    break;
                }
            }
        } else {
            switch (dataComplexCategory) {
                case LIST: 
                case MAP: 
                case STRUCT: 
                case UNION: {
                    dataType = dataComplexCategory.toString();
                    break;
                }
                default: {
                    throw new Error("Unexpected complex category " + (Object)((Object)dataComplexCategory));
                }
            }
        }
        this.logExceptionMessage(bytes, bytesStart, bytesLength, dataType);
    }

    public void logExceptionMessage(byte[] bytes, int bytesStart, int bytesLength, String dataType) {
        try {
            if (LOG.isDebugEnabled()) {
                String byteData = Text.decode((byte[])bytes, (int)bytesStart, (int)bytesLength);
                LOG.debug("Data not in the " + dataType + " data type range so converted to null. Given data is :" + byteData, (Throwable)new Exception("For debugging purposes"));
            }
        }
        catch (CharacterCodingException e1) {
            LOG.debug("Data not in the " + dataType + " data type range so converted to null.", (Throwable)e1);
        }
    }

    public static int byteArrayCompareRanges(byte[] arg1, int start1, byte[] arg2, int start2, int len) {
        for (int i = 0; i < len; ++i) {
            int b1 = arg1[i + start1] & 0xFF;
            int b2 = arg2[i + start2] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return 0;
    }

    private static class UnionComplexTypeHelper
    extends ComplexTypeHelper {
        public Field tagField = new Field(TypeInfoFactory.intTypeInfo);
        public Field[] fields;
        public boolean fieldHaveParsedTag;
        public int fieldTag;

        public UnionComplexTypeHelper(Field complexField, Field[] fields) {
            super(complexField);
            this.fields = fields;
            this.fieldHaveParsedTag = false;
        }
    }

    private static class StructComplexTypeHelper
    extends ComplexTypeHelper {
        public Field[] fields;
        public int nextFieldIndex;

        public StructComplexTypeHelper(Field complexField, Field[] fields) {
            super(complexField);
            this.fields = fields;
            this.nextFieldIndex = 0;
        }
    }

    private static class MapComplexTypeHelper
    extends ComplexTypeHelper {
        public Field keyField;
        public Field valueField;
        public boolean fieldHaveParsedKey;

        public MapComplexTypeHelper(Field complexField, Field keyField, Field valueField) {
            super(complexField);
            this.keyField = keyField;
            this.valueField = valueField;
            this.fieldHaveParsedKey = false;
        }
    }

    private static class ListComplexTypeHelper
    extends ComplexTypeHelper {
        public Field elementField;

        public ListComplexTypeHelper(Field complexField, Field elementField) {
            super(complexField);
            this.elementField = elementField;
        }
    }

    private static class ComplexTypeHelper {
        public final Field complexField;
        public int complexFieldStart;
        public int complexFieldLength;
        public int complexFieldEnd;
        public int fieldPosition;

        public ComplexTypeHelper(Field complexField) {
            this.complexField = complexField;
        }

        public void setCurrentFieldInfo(int complexFieldStart, int complexFieldLength) {
            this.complexFieldStart = complexFieldStart;
            this.complexFieldLength = complexFieldLength;
            this.complexFieldEnd = complexFieldStart + complexFieldLength;
            this.fieldPosition = complexFieldStart;
        }
    }

    private static class Field {
        public final boolean isPrimitive;
        public final PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        public final ObjectInspector.Category complexCategory;
        public final TypeInfo typeInfo;
        public final DataTypePhysicalVariation dataTypePhysicalVariation;
        public ComplexTypeHelper complexTypeHelper;

        public Field(TypeInfo typeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
            ObjectInspector.Category category = typeInfo.getCategory();
            if (category == ObjectInspector.Category.PRIMITIVE) {
                this.isPrimitive = true;
                this.primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                this.complexCategory = null;
            } else {
                this.isPrimitive = false;
                this.primitiveCategory = null;
                this.complexCategory = category;
            }
            this.typeInfo = typeInfo;
            this.dataTypePhysicalVariation = dataTypePhysicalVariation;
            this.complexTypeHelper = null;
        }

        public Field(TypeInfo typeInfo) {
            this(typeInfo, DataTypePhysicalVariation.NONE);
        }
    }
}

