/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import hive.com.google.common.collect.ImmutableList;
import io.netty.util.concurrent.Promise;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.spark.client.JobHandle;
import org.apache.hive.spark.client.MetricsCollection;
import org.apache.hive.spark.client.SparkClientImpl;
import org.apache.hive.spark.counter.SparkCounters;

class JobHandleImpl<T extends Serializable>
implements JobHandle<T> {
    private final SparkClientImpl client;
    private final String jobId;
    private final MetricsCollection metrics;
    private final Promise<T> promise;
    private final List<Integer> sparkJobIds;
    private final List<JobHandle.Listener<T>> listeners;
    private volatile JobHandle.State state;
    private volatile SparkCounters sparkCounters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobHandleImpl(SparkClientImpl client, Promise<T> promise, String jobId, List<JobHandle.Listener<T>> listeners) {
        this.client = client;
        this.jobId = jobId;
        this.promise = promise;
        this.listeners = ImmutableList.copyOf(listeners);
        this.metrics = new MetricsCollection();
        this.sparkJobIds = new CopyOnWriteArrayList<Integer>();
        this.state = JobHandle.State.SENT;
        this.sparkCounters = null;
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            for (JobHandle.Listener<T> listener : this.listeners) {
                this.initializeListener(listener);
            }
        }
    }

    @Override
    public boolean cancel(boolean mayInterrupt) {
        if (this.changeState(JobHandle.State.CANCELLED)) {
            this.client.cancel(this.jobId);
            this.promise.cancel(mayInterrupt);
            return true;
        }
        return false;
    }

    @Override
    public T get() throws ExecutionException, InterruptedException {
        return (T)((Serializable)this.promise.get());
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return (T)((Serializable)this.promise.get(timeout, unit));
    }

    @Override
    public boolean isCancelled() {
        return this.promise.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public String getClientJobId() {
        return this.jobId;
    }

    @Override
    public MetricsCollection getMetrics() {
        return this.metrics;
    }

    @Override
    public List<Integer> getSparkJobIds() {
        return this.sparkJobIds;
    }

    @Override
    public SparkCounters getSparkCounters() {
        return this.sparkCounters;
    }

    @Override
    public JobHandle.State getState() {
        return this.state;
    }

    @Override
    public Throwable getError() {
        return this.promise.cause();
    }

    public void setSparkCounters(SparkCounters sparkCounters) {
        this.sparkCounters = sparkCounters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSuccess(Object result) {
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            this.promise.setSuccess((Object)((Serializable)result));
            this.changeState(JobHandle.State.SUCCEEDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailure(Throwable error) {
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            this.promise.setFailure(error);
            this.changeState(JobHandle.State.FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeState(JobHandle.State newState) {
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            if (newState.ordinal() > this.state.ordinal() && this.state.ordinal() < JobHandle.State.CANCELLED.ordinal()) {
                this.state = newState;
                for (JobHandle.Listener<T> listener : this.listeners) {
                    this.fireStateChange(newState, listener);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSparkJobId(int sparkJobId) {
        List<JobHandle.Listener<T>> list = this.listeners;
        synchronized (list) {
            this.sparkJobIds.add(sparkJobId);
            for (JobHandle.Listener<T> listener : this.listeners) {
                listener.onSparkJobStarted(this, sparkJobId);
            }
        }
    }

    private void initializeListener(JobHandle.Listener<T> listener) {
        if (this.state.ordinal() >= JobHandle.State.CANCELLED.ordinal()) {
            for (Integer id : this.sparkJobIds) {
                listener.onSparkJobStarted(this, id);
            }
        }
        this.fireStateChange(this.state, listener);
        if (this.state.ordinal() < JobHandle.State.CANCELLED.ordinal()) {
            for (Integer id : this.sparkJobIds) {
                listener.onSparkJobStarted(this, id);
            }
        }
    }

    private void fireStateChange(JobHandle.State newState, JobHandle.Listener<T> listener) {
        switch (newState) {
            case SENT: {
                break;
            }
            case QUEUED: {
                listener.onJobQueued(this);
                break;
            }
            case STARTED: {
                listener.onJobStarted(this);
                break;
            }
            case CANCELLED: {
                listener.onJobCancelled(this);
                break;
            }
            case FAILED: {
                listener.onJobFailed(this, this.promise.cause());
                break;
            }
            case SUCCEEDED: {
                try {
                    listener.onJobSucceeded(this, (Serializable)this.promise.get());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void finalize() {
        if (!this.isDone()) {
            this.cancel(true);
        }
    }
}

