/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.AtomObject;
import com.splunk.Service;
import com.splunk.Value;
import java.util.Date;
import java.util.Map;

public abstract class Resource {
    private static final String[] NAMESPACE_COMPONENT_NAMES = new String[]{"app", "owner", "sharing"};
    protected Service service;
    protected String path;
    protected Args refreshArgs;
    protected Map<String, String> actions;
    protected String title;
    protected Date updated;
    private boolean maybeValid = false;

    Resource(Service service, String path) {
        this(service, path, null);
    }

    Resource(Service service, String path, Args args) {
        args = Args.create(args);
        Args namespace = Resource.extractNamespaceFrom(args);
        if (!args.containsKey("count")) {
            args.put("count", "-1");
        }
        this.service = service;
        this.path = service.fullpath(path, namespace.size() == 0 ? null : namespace);
        this.refreshArgs = args;
    }

    private static Args extractNamespaceFrom(Args args) {
        Args namespace = new Args();
        for (String componentName : NAMESPACE_COMPONENT_NAMES) {
            if (!args.containsKey(componentName)) continue;
            namespace.put(componentName, args.get(componentName).toString());
            args.remove(componentName);
        }
        return namespace;
    }

    public String getName() {
        return this.getTitle();
    }

    public String getPath() {
        return this.path;
    }

    public Service getService() {
        return this.service;
    }

    public String getTitle() {
        return this.validate().title;
    }

    public Date getUpdated() {
        return this.validate().updated;
    }

    public Resource invalidate() {
        this.maybeValid = false;
        return this;
    }

    Resource load(AtomObject value) {
        if (value == null) {
            this.title = "title";
        } else {
            this.actions = value.links;
            this.title = value.title;
            this.updated = Value.toDate(value.updated);
        }
        this.maybeValid = true;
        return this;
    }

    public abstract Resource refresh();

    public Resource validate() {
        if (!this.maybeValid) {
            this.refresh();
        }
        return this;
    }
}

