/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.Input;
import com.splunk.InputKind;
import com.splunk.Service;
import com.splunk.Util;
import java.util.Map;

public class WindowsRegistryInput
extends Input {
    WindowsRegistryInput(Service service, String path) {
        super(service, path);
    }

    public boolean getBaseline() {
        return this.getBoolean("baseline");
    }

    public String getProc() {
        return this.getString("proc");
    }

    public String getHive() {
        return this.getString("hive");
    }

    public String getIndex() {
        return this.getString("index");
    }

    @Override
    public InputKind getKind() {
        return InputKind.WindowsRegistry;
    }

    public boolean getMonitorSubnodes() {
        return this.getBoolean("monitorSubnodes", false);
    }

    public String[] getType() {
        if (this.toUpdate.containsKey("type")) {
            String value = (String)this.toUpdate.get("type");
            if (value.contains("|")) {
                return value.split("\\|");
            }
            return new String[]{value};
        }
        if (this.service.versionIsEarlierThan("6.0.0")) {
            return this.getStringArray("type", new String[0]);
        }
        String types = this.getString("type", null);
        if (types == null) {
            return new String[0];
        }
        return types.split("\\|");
    }

    public void setBaseline(boolean baseline) {
        this.setCacheValue("baseline", baseline);
    }

    public void setDisabled(boolean disabled) {
        this.setCacheValue("disabled", disabled);
    }

    public void setHive(String hive) {
        this.setCacheValue("hive", hive);
    }

    public void setIndex(String index) {
        this.setCacheValue("index", index);
    }

    public void setMonitorSubnodes(boolean monitorSubnodes) {
        if (this.service.versionIsAtLeast("6.0.0")) {
            if (this.getHive().endsWith("\\\\?.*")) {
                if (!monitorSubnodes) {
                    this.setHive(this.getHive().substring(0, this.getHive().length() - 5));
                }
            } else if (monitorSubnodes) {
                this.setHive(this.getHive() + "\\\\?.*");
            }
        } else {
            this.setCacheValue("monitorSubnodes", monitorSubnodes);
        }
    }

    public void setProc(String proc) {
        this.setCacheValue("proc", proc);
    }

    public void setType(String[] regexes) {
        String val = Util.join("|", regexes);
        this.setCacheValue("type", val);
    }

    @Override
    public void update(Map<String, Object> args) {
        if (!args.containsKey("baseline")) {
            args = Args.create(args).add("baseline", this.getBaseline());
        }
        if (!args.containsKey("hive")) {
            args = Args.create(args).add("hive", this.getHive());
        }
        if (!args.containsKey("proc")) {
            args = Args.create(args).add("proc", this.getProc());
        }
        if (!args.containsKey("type")) {
            args = Args.create(args).add("type", Util.join("|", this.getType()));
        }
        super.update(args);
    }

    @Override
    public void update() {
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("baseline")) {
            this.setCacheValue("baseline", this.getBaseline());
        }
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("hive")) {
            this.setCacheValue("hive", this.getHive());
        }
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("proc")) {
            this.setCacheValue("proc", this.getProc());
        }
        if (this.toUpdate.size() > 0 && !this.toUpdate.containsKey("type")) {
            this.setCacheValue("type", Util.join("|", this.getType()));
        }
        super.update();
    }
}

