/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute.visitor;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ListJarsQueryPlan;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.TraceQueryPlan;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.ClientAggregatePlan;
import org.apache.phoenix.execute.ClientScanPlan;
import org.apache.phoenix.execute.CursorFetchPlan;
import org.apache.phoenix.execute.HashJoinPlan;
import org.apache.phoenix.execute.LiteralResultIterationPlan;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.execute.SortMergeJoinPlan;
import org.apache.phoenix.execute.TupleProjectionPlan;
import org.apache.phoenix.execute.UnionPlan;
import org.apache.phoenix.execute.UnnestArrayPlan;
import org.apache.phoenix.execute.visitor.QueryPlanVisitor;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.parse.JoinTableNode;

public class RowCountVisitor
implements QueryPlanVisitor<Double> {
    private static final double GROUPING_FACTOR = 0.1;
    private static final double OUTER_JOIN_FACTOR = 1.15;
    private static final double INNER_JOIN_FACTOR = 0.85;
    private static final double SEMI_OR_ANTI_JOIN_FACTOR = 0.5;
    private static final double UNION_DISTINCT_FACTOR = 0.8;

    @Override
    public Double defaultReturn(QueryPlan plan) {
        return null;
    }

    @Override
    public Double visit(AggregatePlan plan) {
        try {
            Long b = plan.getEstimatedRowsToScan();
            if (b != null) {
                return RowCountVisitor.limit(RowCountVisitor.filter(RowCountVisitor.aggregate(RowCountVisitor.filter(b.doubleValue(), RowCountVisitor.stripSkipScanFilter(plan.getContext().getScan().getFilter())), plan.getGroupBy()), plan.getHaving()), plan.getLimit());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Double visit(ScanPlan plan) {
        try {
            Long b = plan.getEstimatedRowsToScan();
            if (b != null) {
                return RowCountVisitor.limit(RowCountVisitor.filter(b.doubleValue(), RowCountVisitor.stripSkipScanFilter(plan.getContext().getScan().getFilter())), plan.getLimit());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Double visit(ClientAggregatePlan plan) {
        Double b = plan.getDelegate().accept(this);
        if (b != null) {
            return RowCountVisitor.limit(RowCountVisitor.filter(RowCountVisitor.aggregate(RowCountVisitor.filter((double)b, plan.getWhere()), plan.getGroupBy()), plan.getHaving()), plan.getLimit());
        }
        return null;
    }

    @Override
    public Double visit(ClientScanPlan plan) {
        if (plan.getLimit() != null) {
            return (double)plan.getLimit();
        }
        Double b = plan.getDelegate().accept(this);
        if (b != null) {
            return RowCountVisitor.limit(RowCountVisitor.filter((double)b, plan.getWhere()), plan.getLimit());
        }
        return null;
    }

    @Override
    public Double visit(LiteralResultIterationPlan plan) {
        return 1.0;
    }

    @Override
    public Double visit(TupleProjectionPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(HashJoinPlan plan) {
        try {
            QueryPlan lhsPlan = plan.getDelegate();
            Long b = lhsPlan.getEstimatedRowsToScan();
            if (b == null) {
                return null;
            }
            Double rows = RowCountVisitor.filter(b.doubleValue(), RowCountVisitor.stripSkipScanFilter(lhsPlan.getContext().getScan().getFilter()));
            JoinTableNode.JoinType[] joinTypes = plan.getJoinInfo().getJoinTypes();
            HashJoinPlan.SubPlan[] subPlans = plan.getSubPlans();
            for (int i = 0; i < joinTypes.length; ++i) {
                Double rhsRows = subPlans[i].getInnerPlan().accept(this);
                if (rhsRows == null) {
                    return null;
                }
                rows = RowCountVisitor.join((double)rows, rhsRows, joinTypes[i]);
            }
            if (lhsPlan instanceof AggregatePlan) {
                AggregatePlan aggPlan = (AggregatePlan)lhsPlan;
                rows = RowCountVisitor.filter(RowCountVisitor.aggregate(rows, aggPlan.getGroupBy()), aggPlan.getHaving());
            }
            return RowCountVisitor.limit(rows, lhsPlan.getLimit());
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    @Override
    public Double visit(SortMergeJoinPlan plan) {
        Double lhsRows = plan.getLhsPlan().accept(this);
        Double rhsRows = plan.getRhsPlan().accept(this);
        if (lhsRows != null && rhsRows != null) {
            return RowCountVisitor.join((double)lhsRows, rhsRows, plan.getJoinType());
        }
        return null;
    }

    @Override
    public Double visit(UnionPlan plan) {
        int count = plan.getSubPlans().size();
        double[] inputRows = new double[count];
        for (int i = 0; i < count; ++i) {
            Double b = plan.getSubPlans().get(i).accept(this);
            if (b == null) {
                return null;
            }
            inputRows[i] = b;
        }
        return RowCountVisitor.limit(RowCountVisitor.union(true, inputRows), plan.getLimit());
    }

    @Override
    public Double visit(UnnestArrayPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(CursorFetchPlan plan) {
        return plan.getDelegate().accept(this);
    }

    @Override
    public Double visit(ListJarsQueryPlan plan) {
        return 0.0;
    }

    @Override
    public Double visit(TraceQueryPlan plan) {
        return 0.0;
    }

    public static Filter stripSkipScanFilter(Filter filter) {
        if (filter == null) {
            return null;
        }
        if (!(filter instanceof FilterList)) {
            return filter instanceof BooleanExpressionFilter ? filter : null;
        }
        FilterList filterList = (FilterList)filter;
        if (filterList.getOperator() != FilterList.Operator.MUST_PASS_ALL) {
            return filter;
        }
        ArrayList<Filter> list = new ArrayList<Filter>();
        for (Filter f : filterList.getFilters()) {
            Filter stripped = RowCountVisitor.stripSkipScanFilter(f);
            if (stripped == null) continue;
            list.add(stripped);
        }
        return list.isEmpty() ? null : (list.size() == 1 ? (Filter)list.get(0) : new FilterList(FilterList.Operator.MUST_PASS_ALL, list));
    }

    public static double filter(double inputRows, Filter filter) {
        if (filter == null) {
            return inputRows;
        }
        return 0.5 * inputRows;
    }

    public static double filter(double inputRows, Expression filter) {
        if (filter == null) {
            return inputRows;
        }
        return 0.5 * inputRows;
    }

    public static double aggregate(double inputRows, GroupByCompiler.GroupBy groupBy) {
        if (groupBy.isUngroupedAggregate()) {
            return 1.0;
        }
        return 0.1 * inputRows;
    }

    public static double limit(double inputRows, Integer limit) {
        if (limit == null) {
            return inputRows;
        }
        return limit.intValue();
    }

    public static double join(double lhsRows, double[] rhsRows, JoinTableNode.JoinType[] types) {
        assert (rhsRows.length == types.length);
        double rows = lhsRows;
        for (int i = 0; i < rhsRows.length; ++i) {
            rows = RowCountVisitor.join(rows, rhsRows[i], types[i]);
        }
        return rows;
    }

    public static double join(double lhsRows, double rhsRows, JoinTableNode.JoinType type) {
        double rows;
        switch (type) {
            case Inner: {
                rows = Math.min(lhsRows, rhsRows);
                rows *= 0.85;
                break;
            }
            case Left: 
            case Right: 
            case Full: {
                rows = Math.max(lhsRows, rhsRows);
                rows *= 1.15;
                break;
            }
            case Semi: 
            case Anti: {
                rows = lhsRows * 0.5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid join type: " + (Object)((Object)type));
            }
        }
        return rows;
    }

    public static double union(boolean all, double ... inputRows) {
        double rows = 0.0;
        for (double d : inputRows) {
            rows += d;
        }
        if (!all) {
            rows *= 0.8;
        }
        return rows;
    }
}

