/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.phoenix.mapreduce.AbstractBulkLoadTool;
import org.apache.phoenix.mapreduce.RegexToKeyValueMapper;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Option;
import org.apache.phoenix.thirdparty.org.apache.commons.cli.Options;
import org.apache.phoenix.util.ColumnInfo;

public class RegexBulkLoadTool
extends AbstractBulkLoadTool {
    static final Option REGEX_OPT = new Option("r", "regex", true, "Input regex String, defaults is (.*)");
    static final Option ARRAY_DELIMITER_OPT = new Option("a", "array-delimiter", true, "Array element delimiter (optional), defaults is ','");

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        options.addOption(REGEX_OPT);
        options.addOption(ARRAY_DELIMITER_OPT);
        return options;
    }

    @Override
    protected void configureOptions(CommandLine cmdLine, List<ColumnInfo> importColumns, Configuration conf) throws SQLException {
        if (cmdLine.hasOption(REGEX_OPT.getOpt())) {
            String regexString = cmdLine.getOptionValue(REGEX_OPT.getOpt());
            conf.set("phoenix.mapreduce.import.regex", regexString);
        }
        if (cmdLine.hasOption(ARRAY_DELIMITER_OPT.getOpt())) {
            String arraySeparator = cmdLine.getOptionValue(ARRAY_DELIMITER_OPT.getOpt());
            conf.set("phoenix.mapreduce.import.arraydelimiter", arraySeparator);
        }
    }

    @Override
    protected void setupJob(Job job) {
        if (job.getJar() == null) {
            job.setJarByClass(RegexToKeyValueMapper.class);
        }
        job.setMapperClass(RegexToKeyValueMapper.class);
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RegexBulkLoadTool(), (String[])args);
    }
}

