/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.EmptySequenceCacheException;
import org.apache.phoenix.schema.SequenceKey;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.math.LongMath;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixKeyValueUtil;
import org.apache.phoenix.util.SequenceUtil;

public class Sequence {
    public static final int SUCCESS = 0;
    private static final Cell CURRENT_VALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES);
    private static final Cell INCREMENT_BY_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.INCREMENT_BY_BYTES);
    private static final Cell CACHE_SIZE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.CACHE_SIZE_BYTES);
    private static final Cell MIN_VALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MIN_VALUE_BYTES);
    private static final Cell MAX_VALUE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.MAX_VALUE_BYTES);
    private static final Cell CYCLE_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.CYCLE_FLAG_BYTES);
    private static final Cell LIMIT_REACHED_KV = KeyValueUtil.createFirstOnRow((byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, (byte[])PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES);
    private static final List<Cell> SEQUENCE_KV_COLUMNS = Arrays.asList(CURRENT_VALUE_KV, INCREMENT_BY_KV, CACHE_SIZE_KV, MIN_VALUE_KV, MAX_VALUE_KV, CYCLE_KV, LIMIT_REACHED_KV);
    private static final int CURRENT_VALUE_INDEX;
    private static final int INCREMENT_BY_INDEX;
    private static final int CACHE_SIZE_INDEX;
    private static final int MIN_VALUE_INDEX;
    private static final int MAX_VALUE_INDEX;
    private static final int CYCLE_INDEX;
    private static final int LIMIT_REACHED_INDEX;
    public static final int NUM_SEQUENCE_KEY_VALUES;
    private static final EmptySequenceCacheException EMPTY_SEQUENCE_CACHE_EXCEPTION;
    private final SequenceKey key;
    private final ReentrantLock lock;
    private List<SequenceValue> values;

    public Sequence(SequenceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.key = key;
        this.lock = new ReentrantLock();
    }

    private void insertSequenceValue(SequenceValue value) {
        if (this.values == null) {
            this.values = Lists.newArrayListWithExpectedSize((int)1);
            this.values.add(value);
        } else {
            int i;
            for (i = this.values.size() - 1; i >= 0 && this.values.get((int)i).timestamp > value.timestamp; --i) {
            }
            if (i >= 0 && this.values.get((int)i).timestamp == value.timestamp) {
                if (this.values.get((int)i).isDeleted) {
                    throw new IllegalStateException("Unexpected delete marker at timestamp " + value.timestamp + " for " + this.key);
                }
                this.values.set(i, value);
            } else {
                this.values.add(i + 1, value);
            }
        }
    }

    private SequenceValue findSequenceValue(long timestamp) {
        int i;
        if (this.values == null) {
            return null;
        }
        for (i = this.values.size() - 1; i >= 0 && this.values.get((int)i).timestamp >= timestamp; --i) {
        }
        if (i < 0) {
            return null;
        }
        SequenceValue value = this.values.get(i);
        return value.isDeleted ? null : value;
    }

    private long increment(SequenceValue value, ValueOp op, long numToAllocate) throws SQLException {
        boolean increasingSeq;
        boolean bl = increasingSeq = value.incrementBy > 0L && op != ValueOp.VALIDATE_SEQUENCE;
        if (value.limitReached && op != ValueOp.VALIDATE_SEQUENCE) {
            if (value.cycle) {
                value.limitReached = false;
                throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
            }
            SQLExceptionCode code = increasingSeq ? SQLExceptionCode.SEQUENCE_VAL_REACHED_MAX_VALUE : SQLExceptionCode.SEQUENCE_VAL_REACHED_MIN_VALUE;
            throw SequenceUtil.getException(this.key.getSchemaName(), this.key.getSequenceName(), code);
        }
        long returnValue = value.currentValue;
        if (op == ValueOp.INCREMENT_SEQUENCE) {
            boolean overflowOrUnderflow = false;
            try {
                value.currentValue = LongMath.checkedAdd((long)value.currentValue, (long)(numToAllocate * value.incrementBy));
            }
            catch (ArithmeticException e) {
                overflowOrUnderflow = true;
            }
            if (overflowOrUnderflow || increasingSeq && value.currentValue > value.maxValue || !increasingSeq && value.currentValue < value.minValue) {
                value.limitReached = true;
            }
        }
        return returnValue;
    }

    public long incrementValue(long timestamp, ValueOp op, long numToAllocate) throws SQLException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        if (this.isSequenceCacheExhausted(numToAllocate, value)) {
            if (op == ValueOp.VALIDATE_SEQUENCE) {
                return value.currentValue;
            }
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return this.increment(value, op, numToAllocate);
    }

    private boolean isSequenceCacheExhausted(long numToAllocate, SequenceValue value) throws SQLException {
        return value.currentValue == value.nextValue || SequenceUtil.isBulkAllocation(numToAllocate) && this.isSequenceCacheExhaustedForBulkAllocation(numToAllocate, value);
    }

    private boolean isSequenceCacheExhaustedForBulkAllocation(long numToAllocate, SequenceValue value) throws SQLException {
        long targetSequenceValue;
        this.performValidationForBulkAllocation(numToAllocate, value);
        try {
            targetSequenceValue = LongMath.checkedAdd((long)value.currentValue, (long)(numToAllocate * value.incrementBy));
        }
        catch (ArithmeticException e) {
            return false;
        }
        if (value.incrementBy > 0L) {
            return targetSequenceValue > value.nextValue;
        }
        return targetSequenceValue < value.nextValue;
    }

    private void performValidationForBulkAllocation(long numToAllocate, SequenceValue value) throws SQLException {
        boolean increasingSeq;
        boolean bl = increasingSeq = value.incrementBy > 0L;
        if (value.cycle && !SequenceUtil.isCycleAllowed(numToAllocate)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NUM_SEQ_TO_ALLOCATE_NOT_SUPPORTED).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
        }
        if (SequenceUtil.checkIfLimitReached(value.currentValue, value.minValue, value.maxValue, value.incrementBy, value.cacheSize, numToAllocate)) {
            throw new SQLExceptionInfo.Builder(SequenceUtil.getLimitReachedErrorCode(increasingSeq)).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
        }
    }

    public List<Append> newReturns() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        ArrayList appends = Lists.newArrayListWithExpectedSize((int)this.values.size());
        for (SequenceValue value : this.values) {
            if (!value.isInitialized() || value.currentValue == value.nextValue) continue;
            appends.add(this.newReturn(value));
        }
        return appends;
    }

    public Append newReturn(long timestamp) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        if (value.currentValue == value.nextValue) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return this.newReturn(value);
    }

    private Append newReturn(SequenceValue value) {
        byte[] key = this.key.getKey();
        Append append = new Append(key);
        byte[] opBuf = new byte[]{(byte)MetaOp.RETURN_SEQUENCE.ordinal()};
        append.setAttribute("SEQUENCE_OPERATION", opBuf);
        append.setAttribute("CURRENT_VALUE", PLong.INSTANCE.toBytes(value.nextValue));
        NavigableMap familyMap = append.getFamilyCellMap();
        familyMap.put(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, Arrays.asList(PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, value.timestamp, PLong.INSTANCE.toBytes(value.currentValue)), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES, value.timestamp, PBoolean.INSTANCE.toBytes(value.limitReached))));
        return append;
    }

    public long currentValue(long timestamp) throws EmptySequenceCacheException {
        SequenceValue value = this.findSequenceValue(timestamp);
        if (value == null || value.isUnitialized()) {
            throw EMPTY_SEQUENCE_CACHE_EXCEPTION;
        }
        return value.currentValue - value.incrementBy;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public SequenceKey getKey() {
        return this.key;
    }

    public long incrementValue(Result result, ValueOp op, long numToAllocate) throws SQLException {
        if (result.rawCells().length == 1) {
            Cell errorKV = result.rawCells()[0];
            int errorCode = PInteger.INSTANCE.getCodec().decodeInt(errorKV.getValueArray(), errorKV.getValueOffset(), SortOrder.getDefault());
            SQLExceptionCode code = SQLExceptionCode.fromErrorCode(errorCode);
            throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
        }
        SequenceValue value = new SequenceValue(result, op, numToAllocate);
        this.insertSequenceValue(value);
        return this.increment(value, op, numToAllocate);
    }

    public Increment newIncrement(long timestamp, ValueOp action, long numToAllocate) {
        byte[] incKey = this.key.getKey();
        byte[] incValue = Bytes.toBytes((long)action.ordinal());
        Increment inc = new Increment(incKey);
        try {
            inc.setTimeRange(0L, timestamp);
            inc.setAttribute("NUM_TO_ALLOCATE", Bytes.toBytes((long)numToAllocate));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Cell kv : SEQUENCE_KV_COLUMNS) {
            try {
                KeyValue cell = new KeyValue(incKey, 0, incKey.length, kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), timestamp, KeyValue.Type.Put, incValue, 0, incValue.length);
                inc.add((Cell)cell);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return inc;
    }

    private static Cell getKeyValue(Result r, Cell kv, int cellIndex) {
        Cell[] cells = r.rawCells();
        return cells.length == NUM_SEQUENCE_KEY_VALUES ? cells[cellIndex] : r.getColumnLatestCell(kv.getFamilyArray(), kv.getFamilyOffset(), (int)kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    private static Cell getKeyValue(Result r, Cell kv) {
        return Sequence.getKeyValue(r, kv, SEQUENCE_KV_COLUMNS.indexOf(kv));
    }

    public static Cell getCurrentValueKV(Result r) {
        return Sequence.getKeyValue(r, CURRENT_VALUE_KV, CURRENT_VALUE_INDEX);
    }

    public static Cell getIncrementByKV(Result r) {
        return Sequence.getKeyValue(r, INCREMENT_BY_KV, INCREMENT_BY_INDEX);
    }

    public static Cell getCacheSizeKV(Result r) {
        return Sequence.getKeyValue(r, CACHE_SIZE_KV, CACHE_SIZE_INDEX);
    }

    public static Cell getMinValueKV(Result r) {
        return Sequence.getKeyValue(r, MIN_VALUE_KV, MIN_VALUE_INDEX);
    }

    public static Cell getMaxValueKV(Result r) {
        return Sequence.getKeyValue(r, MAX_VALUE_KV, MAX_VALUE_INDEX);
    }

    public static Cell getCycleKV(Result r) {
        return Sequence.getKeyValue(r, CYCLE_KV, CYCLE_INDEX);
    }

    public static Cell getLimitReachedKV(Result r) {
        return Sequence.getKeyValue(r, LIMIT_REACHED_KV, LIMIT_REACHED_INDEX);
    }

    public static void replaceCurrentValueKV(List<Cell> kvs, Cell currentValueKV) {
        kvs.set(CURRENT_VALUE_INDEX, currentValueKV);
    }

    public static void replaceMinValueKV(List<Cell> kvs, Cell minValueKV) {
        kvs.set(MIN_VALUE_INDEX, minValueKV);
    }

    public static void replaceMaxValueKV(List<Cell> kvs, Cell maxValueKV) {
        kvs.set(MAX_VALUE_INDEX, maxValueKV);
    }

    public static void replaceCycleValueKV(List<Cell> kvs, Cell cycleValueKV) {
        kvs.set(CYCLE_INDEX, cycleValueKV);
    }

    public static void replaceLimitReachedKV(List<Cell> kvs, Cell limitReachedKV) {
        kvs.set(LIMIT_REACHED_INDEX, limitReachedKV);
    }

    public static List<Cell> getCells(Result r, int numKVs) {
        if (r.rawCells().length == numKVs) {
            return Lists.newArrayList((Object[])r.rawCells());
        }
        ArrayList cellList = Lists.newArrayListWithCapacity((int)NUM_SEQUENCE_KEY_VALUES);
        for (Cell kv : SEQUENCE_KV_COLUMNS) {
            cellList.add(Sequence.getKeyValue(r, kv));
        }
        return cellList;
    }

    public boolean returnValue(Result result) throws SQLException {
        Cell statusKV = result.rawCells()[0];
        if (statusKV.getValueLength() == 0) {
            return false;
        }
        long timestamp = statusKV.getTimestamp();
        int statusCode = PInteger.INSTANCE.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        if (statusCode == 0) {
            SequenceValue value = this.findSequenceValue(timestamp);
            if (value == null) {
                throw new EmptySequenceCacheException(this.key.getSchemaName(), this.key.getSequenceName());
            }
            return true;
        }
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public Append createSequence(long startWith, long incrementBy, long cacheSize, long timestamp, long minValue, long maxValue, boolean cycle) {
        byte[] key = this.key.getKey();
        Append append = new Append(key);
        append.setAttribute("SEQUENCE_OPERATION", new byte[]{(byte)MetaOp.CREATE_SEQUENCE.ordinal()});
        if (timestamp != Long.MAX_VALUE) {
            append.setAttribute("MAX_TIMERANGE", Bytes.toBytes((long)timestamp));
        }
        NavigableMap familyMap = append.getFamilyCellMap();
        byte[] startWithBuf = PLong.INSTANCE.toBytes(startWith);
        familyMap.put(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, Arrays.asList(PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, ByteUtil.EMPTY_BYTE_ARRAY), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CURRENT_VALUE_BYTES, timestamp, startWithBuf), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.START_WITH_BYTES, timestamp, startWithBuf), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.INCREMENT_BY_BYTES, timestamp, PLong.INSTANCE.toBytes(incrementBy)), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CACHE_SIZE_BYTES, timestamp, PLong.INSTANCE.toBytes(cacheSize)), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_VALUE_BYTES, timestamp, PLong.INSTANCE.toBytes(minValue)), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.MAX_VALUE_BYTES, timestamp, PLong.INSTANCE.toBytes(maxValue)), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.CYCLE_FLAG_BYTES, timestamp, PBoolean.INSTANCE.toBytes(cycle)), PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, PhoenixDatabaseMetaData.LIMIT_REACHED_FLAG_BYTES, timestamp, PDataType.FALSE_BYTES)));
        return append;
    }

    public long createSequence(Result result, long minValue, long maxValue, boolean cycle) throws SQLException {
        Cell statusKV = result.rawCells()[0];
        long timestamp = statusKV.getTimestamp();
        int statusCode = PInteger.INSTANCE.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        if (statusCode == 0) {
            SequenceValue value = new SequenceValue(timestamp, minValue, maxValue, cycle);
            this.insertSequenceValue(value);
            return timestamp;
        }
        SQLExceptionCode code = SQLExceptionCode.fromErrorCode(statusCode);
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public Append dropSequence(long timestamp) {
        byte[] key = this.key.getKey();
        Append append = new Append(key);
        append.setAttribute("SEQUENCE_OPERATION", new byte[]{(byte)MetaOp.DROP_SEQUENCE.ordinal()});
        if (timestamp != Long.MAX_VALUE) {
            append.setAttribute("MAX_TIMERANGE", Bytes.toBytes((long)timestamp));
        }
        NavigableMap familyMap = append.getFamilyCellMap();
        familyMap.put(PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, Arrays.asList(PhoenixKeyValueUtil.newKeyValue(key, PhoenixDatabaseMetaData.SYSTEM_SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, ByteUtil.EMPTY_BYTE_ARRAY)));
        return append;
    }

    public long dropSequence(Result result) throws SQLException {
        SQLExceptionCode code;
        Cell statusKV = result.rawCells()[0];
        long timestamp = statusKV.getTimestamp();
        int statusCode = PInteger.INSTANCE.getCodec().decodeInt(statusKV.getValueArray(), statusKV.getValueOffset(), SortOrder.getDefault());
        SQLExceptionCode sQLExceptionCode = code = statusCode == 0 ? null : SQLExceptionCode.fromErrorCode(statusCode);
        if (code == null) {
            this.insertSequenceValue(new SequenceValue(timestamp, true));
            return timestamp;
        }
        throw new SQLExceptionInfo.Builder(code).setSchemaName(this.key.getSchemaName()).setTableName(this.key.getSequenceName()).build().buildException();
    }

    public static String getCreateTableStatement(String schema, int nSaltBuckets) {
        if (nSaltBuckets <= 0) {
            return schema;
        }
        return schema + "," + "SALT_BUCKETS" + "=" + nSaltBuckets;
    }

    static {
        Collections.sort(SEQUENCE_KV_COLUMNS, CellComparatorImpl.COMPARATOR);
        CURRENT_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CURRENT_VALUE_KV);
        INCREMENT_BY_INDEX = SEQUENCE_KV_COLUMNS.indexOf(INCREMENT_BY_KV);
        CACHE_SIZE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CACHE_SIZE_KV);
        MIN_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(MIN_VALUE_KV);
        MAX_VALUE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(MAX_VALUE_KV);
        CYCLE_INDEX = SEQUENCE_KV_COLUMNS.indexOf(CYCLE_KV);
        LIMIT_REACHED_INDEX = SEQUENCE_KV_COLUMNS.indexOf(LIMIT_REACHED_KV);
        NUM_SEQUENCE_KEY_VALUES = SEQUENCE_KV_COLUMNS.size();
        EMPTY_SEQUENCE_CACHE_EXCEPTION = new EmptySequenceCacheException();
    }

    private static final class SequenceValue {
        public final long incrementBy;
        public final long timestamp;
        public final long cacheSize;
        public long currentValue;
        public long nextValue;
        public long minValue;
        public long maxValue;
        public boolean cycle;
        public boolean isDeleted;
        public boolean limitReached;

        public SequenceValue(long timestamp, long minValue, long maxValue, boolean cycle) {
            this(timestamp, false);
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.cycle = cycle;
        }

        public SequenceValue(long timestamp, boolean isDeleted) {
            this.timestamp = timestamp;
            this.isDeleted = isDeleted;
            this.incrementBy = 0L;
            this.limitReached = false;
            this.cacheSize = 0L;
        }

        public boolean isInitialized() {
            return this.incrementBy != 0L;
        }

        public boolean isUnitialized() {
            return this.incrementBy == 0L;
        }

        public SequenceValue(Result r, ValueOp op, long numToAllocate) {
            Cell currentValueKV = Sequence.getCurrentValueKV(r);
            Cell incrementByKV = Sequence.getIncrementByKV(r);
            Cell cacheSizeKV = Sequence.getCacheSizeKV(r);
            Cell minValueKV = Sequence.getMinValueKV(r);
            Cell maxValueKV = Sequence.getMaxValueKV(r);
            Cell cycleKV = Sequence.getCycleKV(r);
            this.timestamp = currentValueKV.getTimestamp();
            this.nextValue = PLong.INSTANCE.getCodec().decodeLong(currentValueKV.getValueArray(), currentValueKV.getValueOffset(), SortOrder.getDefault());
            this.incrementBy = PLong.INSTANCE.getCodec().decodeLong(incrementByKV.getValueArray(), incrementByKV.getValueOffset(), SortOrder.getDefault());
            this.cacheSize = PLong.INSTANCE.getCodec().decodeLong(cacheSizeKV.getValueArray(), cacheSizeKV.getValueOffset(), SortOrder.getDefault());
            this.minValue = PLong.INSTANCE.getCodec().decodeLong(minValueKV.getValueArray(), minValueKV.getValueOffset(), SortOrder.getDefault());
            this.maxValue = PLong.INSTANCE.getCodec().decodeLong(maxValueKV.getValueArray(), maxValueKV.getValueOffset(), SortOrder.getDefault());
            this.cycle = (Boolean)PBoolean.INSTANCE.toObject(cycleKV.getValueArray(), cycleKV.getValueOffset(), cycleKV.getValueLength());
            this.limitReached = false;
            this.currentValue = this.nextValue;
            if (op != ValueOp.VALIDATE_SEQUENCE) {
                this.currentValue -= this.incrementBy * (SequenceUtil.isBulkAllocation(numToAllocate) ? numToAllocate : this.cacheSize);
            }
        }
    }

    public static enum MetaOp {
        CREATE_SEQUENCE,
        DROP_SEQUENCE,
        RETURN_SEQUENCE;

    }

    public static enum ValueOp {
        VALIDATE_SEQUENCE,
        INCREMENT_SEQUENCE;

    }
}

