/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util.csv;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVRecord;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.expression.function.EncodeFormat;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.types.PBinary;
import org.apache.phoenix.schema.types.PBoolean;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PTimestamp;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.phoenix.thirdparty.com.google.common.base.Function;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.UpsertExecutor;
import org.apache.phoenix.util.csv.StringToArrayConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUpsertExecutor
extends UpsertExecutor<CSVRecord, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvUpsertExecutor.class);
    protected final String arrayElementSeparator;

    @VisibleForTesting
    protected CsvUpsertExecutor(Connection conn, List<ColumnInfo> columnInfoList, PreparedStatement stmt, UpsertExecutor.UpsertListener<CSVRecord> upsertListener, String arrayElementSeparator) {
        super(conn, columnInfoList, stmt, upsertListener);
        this.arrayElementSeparator = arrayElementSeparator;
        this.finishInit();
    }

    public CsvUpsertExecutor(Connection conn, String tableName, List<ColumnInfo> columnInfoList, UpsertExecutor.UpsertListener<CSVRecord> upsertListener, String arrayElementSeparator) {
        super(conn, tableName, columnInfoList, upsertListener);
        this.arrayElementSeparator = arrayElementSeparator;
        this.finishInit();
    }

    @Override
    protected void execute(CSVRecord csvRecord) {
        try {
            if (csvRecord.size() < this.conversionFunctions.size()) {
                String message = String.format("CSV record does not have enough values (has %d, but needs %d)", csvRecord.size(), this.conversionFunctions.size());
                throw new IllegalArgumentException(message);
            }
            for (int fieldIndex = 0; fieldIndex < this.conversionFunctions.size(); ++fieldIndex) {
                Object sqlValue = ((Function)this.conversionFunctions.get(fieldIndex)).apply((Object)csvRecord.get(fieldIndex));
                if (sqlValue != null) {
                    this.preparedStatement.setObject(fieldIndex + 1, sqlValue);
                    continue;
                }
                this.preparedStatement.setNull(fieldIndex + 1, ((PDataType)this.dataTypes.get(fieldIndex)).getSqlType());
            }
            this.preparedStatement.execute();
            this.upsertListener.upsertDone(++this.upsertCount);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error on CSVRecord " + csvRecord, (Throwable)e);
            }
            this.upsertListener.errorOnRecord(csvRecord, e);
        }
    }

    @Override
    protected Function<String, Object> createConversionFunction(PDataType dataType) {
        if (dataType.isArrayType()) {
            return new ArrayDatatypeConversionFunction(new StringToArrayConverter(this.conn, this.arrayElementSeparator, PDataType.fromTypeId(dataType.getSqlType() - 3000)));
        }
        return new SimpleDatatypeConversionFunction(dataType, this.conn);
    }

    private static class ArrayDatatypeConversionFunction
    implements Function<String, Object> {
        private final StringToArrayConverter arrayConverter;

        private ArrayDatatypeConversionFunction(StringToArrayConverter arrayConverter) {
            this.arrayConverter = arrayConverter;
        }

        @Nullable
        public Object apply(@Nullable String input) {
            try {
                return this.arrayConverter.toArray(input);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class SimpleDatatypeConversionFunction
    implements Function<String, Object> {
        private final PDataType dataType;
        private final PDataType.PDataCodec codec;
        private final DateUtil.DateTimeParser dateTimeParser;
        private final String binaryEncoding;

        SimpleDatatypeConversionFunction(PDataType dataType, Connection conn) {
            ReadOnlyProps props;
            try {
                props = conn.unwrap(PhoenixConnection.class).getQueryServices().getProps();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            this.dataType = dataType;
            PDataType.PDataCodec codec = dataType.getCodec();
            if (dataType.isCoercibleTo(PTimestamp.INSTANCE)) {
                codec = DateUtil.getCodecFor(dataType);
                int dateSqlType = dataType.getResultSetSqlType();
                String dateFormat = dateSqlType == 91 ? props.get("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss.SSS") : (dateSqlType == 92 ? props.get("phoenix.query.timeFormat", "yyyy-MM-dd HH:mm:ss.SSS") : props.get("phoenix.query.timestampFormat", "yyyy-MM-dd HH:mm:ss.SSS"));
                String timeZoneId = props.get("phoenix.query.dateFormatTimeZone", "GMT");
                this.dateTimeParser = DateUtil.getDateTimeParser(dateFormat, dataType, timeZoneId);
            } else {
                this.dateTimeParser = null;
            }
            this.codec = codec;
            this.binaryEncoding = props.get("phoenix.upload.binaryDataType.encoding", "BASE64");
        }

        @Nullable
        public Object apply(@Nullable String input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            if (this.dataType == PTimestamp.INSTANCE) {
                return DateUtil.parseTimestamp(input);
            }
            if (this.dateTimeParser != null) {
                long epochTime = this.dateTimeParser.parseDateTime(input);
                byte[] byteValue = new byte[this.dataType.getByteSize().intValue()];
                this.codec.encodeLong(epochTime, byteValue, 0);
                return this.dataType.toObject(byteValue);
            }
            if (this.dataType == PBoolean.INSTANCE) {
                switch (input.toLowerCase()) {
                    case "true": 
                    case "t": 
                    case "1": {
                        return Boolean.TRUE;
                    }
                    case "false": 
                    case "f": 
                    case "0": {
                        return Boolean.FALSE;
                    }
                }
                throw new RuntimeException("Invalid boolean value: '" + input + "', must be one of ['true','t','1','false','f','0']");
            }
            if (this.dataType == PVarbinary.INSTANCE || this.dataType == PBinary.INSTANCE) {
                EncodeFormat format = EncodeFormat.valueOf(this.binaryEncoding.toUpperCase());
                byte[] object = null;
                switch (format) {
                    case BASE64: {
                        object = Base64.getDecoder().decode(input);
                        if (object != null) break;
                        throw new IllegalDataException("Input: [" + input + "]  is not base64 encoded");
                    }
                    case ASCII: {
                        object = Bytes.toBytes((String)input);
                        break;
                    }
                    default: {
                        throw new IllegalDataException("Unsupported encoding \"" + this.binaryEncoding + "\"");
                    }
                }
                return object;
            }
            return this.dataType.toObject(input);
        }
    }
}

