/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import org.apache.drill.yarn.appMaster.AbstractScheduler;
import org.apache.drill.yarn.appMaster.Task;

public class BatchScheduler
extends AbstractScheduler {
    private int quantity;
    private int completedCount;

    public BatchScheduler(String name, int quantity) {
        super("batch", name);
        this.quantity = quantity;
    }

    @Override
    public void completed(Task task) {
        ++this.completedCount;
        if (task.getDisposition() != Task.Disposition.COMPLETED) {
            ++this.failCount;
        }
    }

    @Override
    public int resize(int level) {
        this.quantity = level;
        return this.quantity;
    }

    @Override
    public int getTarget() {
        return this.quantity;
    }

    @Override
    public int[] getProgress() {
        return new int[]{Math.min(this.completedCount, this.quantity), this.quantity};
    }

    @Override
    public void adjust() {
        int activeCount = this.state.getTaskCount();
        int delta = this.quantity - activeCount - this.completedCount;
        if (delta < 0) {
            this.addTasks(-delta);
        }
        if (delta > 0) {
            this.cancelTasks(delta);
        }
    }

    private void cancelTasks(int n) {
        for (Task task : this.state.getStartingTasks()) {
            this.state.cancel(task);
            if (--n != 0) continue;
            break;
        }
    }

    @Override
    public boolean hasMoreTasks() {
        return this.completedCount < this.quantity;
    }

    @Override
    public void requestTimedOut() {
    }
}

