/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.object.datatype.DataType;
import io.jhdf.storage.HdfBackingStorage;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.stream.IntStream;

public class OpaqueDataType
extends DataType {
    private final String asciiTag;

    public OpaqueDataType(ByteBuffer bb) {
        super(bb);
        int asciiTagLength = Utils.bitsToInt(this.classBits, 0, 8);
        this.asciiTag = Utils.readUntilNull(Utils.createSubBuffer(bb, asciiTagLength));
    }

    public String getAsciiTag() {
        return this.asciiTag;
    }

    @Override
    public Class<?> getJavaType() {
        return byte[].class;
    }

    @Override
    public Object fillData(ByteBuffer buffer, int[] dimensions, HdfBackingStorage hdfBackingStorage) {
        int elements = IntStream.of(dimensions).reduce(1, Math::multiplyExact);
        int elementSize = buffer.remaining() / elements;
        Object data = Array.newInstance(this.getJavaType(), dimensions);
        OpaqueDataType.fillOpaquedData(data, dimensions, buffer, elementSize);
        return data;
    }

    private static void fillOpaquedData(Object data, int[] dims, ByteBuffer buffer, int elementSize) {
        if (dims.length > 1) {
            for (int i = 0; i < dims[0]; ++i) {
                Object newArray = Array.get(data, i);
                OpaqueDataType.fillOpaquedData(newArray, Utils.stripLeadingIndex(dims), buffer, elementSize);
            }
        } else {
            for (int i = 0; i < Array.getLength(data); ++i) {
                byte[] bytes = new byte[elementSize];
                buffer.get(bytes);
                Array.set(data, i, bytes);
            }
        }
    }
}

