/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.impl.hive;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.fn.impl.StringFunctionHelpers;
import org.apache.drill.exec.expr.fn.impl.hive.AbstractDrillPrimitiveObjectInspector;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;

public class DrillVarCharStringObjectInspector {

    public static class Optional
    extends AbstractDrillPrimitiveObjectInspector
    implements StringObjectInspector {
        public Optional() {
            super(TypeInfoFactory.stringTypeInfo);
        }

        public Text getPrimitiveWritableObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVarCharHolder h = (NullableVarCharHolder)o;
            return new Text(StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer));
        }

        public String getPrimitiveJavaObject(Object o) {
            if (o == null) {
                return null;
            }
            NullableVarCharHolder h = (NullableVarCharHolder)o;
            return StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer);
        }
    }

    public static class Required
    extends AbstractDrillPrimitiveObjectInspector
    implements StringObjectInspector {
        public Required() {
            super(TypeInfoFactory.stringTypeInfo);
        }

        public Text getPrimitiveWritableObject(Object o) {
            VarCharHolder h = (VarCharHolder)o;
            return new Text(StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer));
        }

        public String getPrimitiveJavaObject(Object o) {
            VarCharHolder h = (VarCharHolder)o;
            return StringFunctionHelpers.toStringFromUTF8((int)h.start, (int)h.end, (DrillBuf)h.buffer);
        }
    }
}

