/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import io.netty.buffer.DrillBuf;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.util.BitSets;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.AbstractPartitionDescriptor;
import org.apache.drill.exec.planner.PartitionLocation;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.HivePartitionLocation;
import org.apache.drill.exec.server.options.OptionSet;
import org.apache.drill.exec.store.hive.HiveReadEntry;
import org.apache.drill.exec.store.hive.HiveScan;
import org.apache.drill.exec.store.hive.HiveTableWrapper;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class HivePartitionDescriptor
extends AbstractPartitionDescriptor {
    private final Map<String, Integer> partitionMap = new HashMap<String, Integer>();
    private final int numPartitionLevels;
    private final DrillScanRel scanRel;
    private final String defaultPartitionValue;
    private final DrillBuf managedBuffer;

    public HivePartitionDescriptor(PlannerSettings settings, DrillScanRel scanRel, DrillBuf managedBuffer, String defaultPartitionValue) {
        int i = 0;
        this.scanRel = scanRel;
        this.managedBuffer = managedBuffer.reallocIfNeeded(256);
        this.defaultPartitionValue = defaultPartitionValue;
        for (HiveTableWrapper.FieldSchemaWrapper wrapper : ((HiveScan)scanRel.getGroupScan()).getHiveReadEntry().table.partitionKeys) {
            this.partitionMap.put(wrapper.name, i);
            ++i;
        }
        this.numPartitionLevels = i;
    }

    public int getPartitionHierarchyIndex(String partitionName) {
        return this.partitionMap.get(partitionName);
    }

    public boolean isPartitionName(String name) {
        return this.partitionMap.get(name) != null;
    }

    public int getMaxHierarchyLevel() {
        return this.numPartitionLevels;
    }

    public Path getBaseTableLocation() {
        HiveReadEntry origEntry = ((HiveScan)this.scanRel.getGroupScan()).getHiveReadEntry();
        return new Path(origEntry.table.getTable().getSd().getLocation());
    }

    public void populatePartitionVectors(ValueVector[] vectors, List<PartitionLocation> partitions, BitSet partitionColumnBitSet, Map<Integer, String> fieldNameMap) {
        int record = 0;
        HiveScan hiveScan = (HiveScan)this.scanRel.getGroupScan();
        Map<String, String> partitionNameTypeMap = hiveScan.getHiveReadEntry().table.getPartitionNameTypeMap();
        for (PartitionLocation partitionLocation : partitions) {
            Iterator iterator = BitSets.toIter((BitSet)partitionColumnBitSet).iterator();
            while (iterator.hasNext()) {
                int partitionColumnIndex = (Integer)iterator.next();
                String hiveType = partitionNameTypeMap.get(fieldNameMap.get(partitionColumnIndex));
                Object value = HiveUtilities.convertPartitionType(TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType), partitionLocation.getPartitionValue(partitionColumnIndex), this.defaultPartitionValue);
                if (value == null) continue;
                HiveUtilities.populateVector(vectors[partitionColumnIndex], this.managedBuffer, value, record, record + 1);
            }
            ++record;
        }
        for (ValueVector v : vectors) {
            if (v == null) continue;
            v.getMutator().setValueCount(partitions.size());
        }
    }

    public TypeProtos.MajorType getVectorType(SchemaPath column, PlannerSettings plannerSettings) {
        HiveScan hiveScan = (HiveScan)this.scanRel.getGroupScan();
        String partitionName = column.getAsNamePart().getName();
        Map<String, String> partitionNameTypeMap = hiveScan.getHiveReadEntry().table.getPartitionNameTypeMap();
        String hiveType = partitionNameTypeMap.get(partitionName);
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)hiveType);
        TypeProtos.MinorType partitionType = HiveUtilities.getMinorTypeFromHivePrimitiveTypeInfo(primitiveTypeInfo, (OptionSet)plannerSettings.getOptions());
        return TypeProtos.MajorType.newBuilder().setMode(TypeProtos.DataMode.OPTIONAL).setMinorType(partitionType).build();
    }

    public Integer getIdIfValid(String name) {
        return this.partitionMap.get(name);
    }

    protected void createPartitionSublists() {
        LinkedList<HivePartitionLocation> locations = new LinkedList<HivePartitionLocation>();
        HiveReadEntry origEntry = ((HiveScan)this.scanRel.getGroupScan()).getHiveReadEntry();
        for (Partition partition : origEntry.getPartitions()) {
            locations.add(new HivePartitionLocation(partition.getValues(), new Path(partition.getSd().getLocation())));
        }
        this.locationSuperList = Lists.partition(locations, (int)65535);
        this.sublistsCreated = true;
    }

    public TableScan createTableScan(List<PartitionLocation> newPartitions, boolean wasAllPartitionsPruned) throws Exception {
        GroupScan newGroupScan = this.createNewGroupScan(newPartitions);
        return new DrillScanRel(this.scanRel.getCluster(), this.scanRel.getTraitSet().plus((RelTrait)DrillRel.DRILL_LOGICAL), this.scanRel.getTable(), newGroupScan, this.scanRel.getRowType(), this.scanRel.getColumns(), true);
    }

    private GroupScan createNewGroupScan(List<PartitionLocation> newPartitionLocations) throws ExecutionSetupException {
        HiveScan hiveScan = (HiveScan)this.scanRel.getGroupScan();
        HiveReadEntry origReadEntry = hiveScan.getHiveReadEntry();
        List<HiveTableWrapper.HivePartitionWrapper> oldPartitions = origReadEntry.partitions;
        LinkedList newPartitions = Lists.newLinkedList();
        for (HiveTableWrapper.HivePartitionWrapper part : oldPartitions) {
            Path partitionLocation = new Path(part.getPartition().getSd().getLocation());
            for (PartitionLocation newPartitionLocation : newPartitionLocations) {
                if (!partitionLocation.equals((Object)newPartitionLocation.getEntirePartitionLocation())) continue;
                newPartitions.add(part);
            }
        }
        HiveReadEntry newReadEntry = new HiveReadEntry(origReadEntry.table, newPartitions);
        return hiveScan.clone(newReadEntry);
    }
}

