/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.calcite.schema.Schema;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveTableWrapper;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.hadoop.hive.metastore.TableType;

public class HiveReadEntry
implements DrillTableSelection {
    @JsonProperty(value="table")
    public HiveTableWrapper table;
    @JsonProperty(value="partitions")
    public List<HiveTableWrapper.HivePartitionWrapper> partitions;
    @JsonIgnore
    private List<HivePartition> partitionsUnwrapped = Lists.newArrayList();

    @JsonCreator
    public HiveReadEntry(@JsonProperty(value="table") HiveTableWrapper table, @JsonProperty(value="partitions") List<HiveTableWrapper.HivePartitionWrapper> partitions) {
        this.table = table;
        this.partitions = partitions;
        if (partitions != null) {
            for (HiveTableWrapper.HivePartitionWrapper part : partitions) {
                this.partitionsUnwrapped.add(part.getPartition());
            }
        }
    }

    @JsonIgnore
    public HiveTableWithColumnCache getTable() {
        return this.table.getTable();
    }

    @JsonIgnore
    public HiveTableWrapper getTableWrapper() {
        return this.table;
    }

    @JsonIgnore
    public List<HivePartition> getPartitions() {
        return this.partitionsUnwrapped;
    }

    @JsonIgnore
    public HiveTableWrapper getHiveTableWrapper() {
        return this.table;
    }

    @JsonIgnore
    public List<HiveTableWrapper.HivePartitionWrapper> getHivePartitionWrappers() {
        return this.partitions;
    }

    @JsonIgnore
    public Schema.TableType getJdbcTableType() {
        if (this.table.getTable().getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
            return Schema.TableType.VIEW;
        }
        return Schema.TableType.TABLE;
    }

    public String getPartitionLocation(HiveTableWrapper.HivePartitionWrapper partition) {
        String partitionPath = this.table.getTable().getSd().getLocation();
        for (String value : partition.values) {
            partitionPath = partitionPath + "/" + value;
        }
        return partitionPath;
    }

    public String toString() {
        return new PlanStringBuilder((Object)this).field("tableName", (Object)this.table).field("partitions", this.partitions).toString();
    }

    public String digest() {
        return this.toString();
    }
}

