/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.hive.readers;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.store.hive.HivePartition;
import org.apache.drill.exec.store.hive.HiveTableWithColumnCache;
import org.apache.drill.exec.store.hive.HiveUtilities;
import org.apache.drill.exec.store.hive.readers.HiveDefaultRecordReader;
import org.apache.drill.exec.store.hive.readers.inspectors.SkipFooterRecordsInspector;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveTextRecordReader
extends HiveDefaultRecordReader {
    private SkipFooterRecordsInspector skipFooterValueHolder;

    public HiveTextRecordReader(HiveTableWithColumnCache table, HivePartition partition, Collection<InputSplit> inputSplits, List<SchemaPath> projectedColumns, FragmentContext context, HiveConf hiveConf, UserGroupInformation proxyUgi) {
        super(table, partition, inputSplits, projectedColumns, context, hiveConf, proxyUgi);
    }

    @Override
    protected void internalInit(Properties hiveTableProperties) {
        int skipFooterCount;
        int skipHeaderCount = HiveUtilities.retrieveIntProperty(hiveTableProperties, "skip.header.line.count", -1);
        try {
            for (int i = 0; i < skipHeaderCount; ++i) {
                if (this.hasNextValue(this.valueHolder)) continue;
                this.empty = true;
                break;
            }
        }
        catch (IOException | ExecutionSetupException e) {
            throw new DrillRuntimeException(e.getMessage(), e);
        }
        if (!this.empty && (skipFooterCount = HiveUtilities.retrieveIntProperty(hiveTableProperties, "skip.footer.line.count", -1)) > 0) {
            this.skipFooterValueHolder = new SkipFooterRecordsInspector((RecordReader<Object, Object>)this.mapredReader, skipFooterCount);
        }
    }

    @Override
    public int next() {
        if (this.skipFooterValueHolder == null) {
            return super.next();
        }
        try {
            this.skipFooterValueHolder.reset();
            while (!this.skipFooterValueHolder.isBatchFull() && this.hasNextValue(this.skipFooterValueHolder.getValueHolder())) {
                Object value = this.skipFooterValueHolder.getNextValue();
                if (value == null) continue;
                Object deSerializedValue = this.partitionToTableSchemaConverter.convert(this.partitionDeserializer.deserialize((Writable)value));
                this.outputWriter.setPosition(this.skipFooterValueHolder.getProcessedRecordCount());
                this.readHiveRecordAndInsertIntoRecordBatch(deSerializedValue);
                this.skipFooterValueHolder.incrementProcessedRecordCount();
            }
            this.outputWriter.setValueCount(this.skipFooterValueHolder.getProcessedRecordCount());
            return this.skipFooterValueHolder.getProcessedRecordCount();
        }
        catch (IOException | ExecutionSetupException | SerDeException e) {
            throw new DrillRuntimeException(e.getMessage(), e);
        }
    }
}

