/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.drill.exec.record.ColumnConverter;
import org.apache.drill.exec.record.ColumnConverterFactory;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.TupleWriter;
import org.apache.drill.exec.vector.accessor.ValueWriter;

public class ElasticsearchColumnConverterFactory
extends ColumnConverterFactory {
    public ElasticsearchColumnConverterFactory(TupleMetadata providedSchema) {
        super(providedSchema);
    }

    public ColumnConverter.ScalarColumnConverter buildScalar(ColumnMetadata readerSchema, ValueWriter writer) {
        switch (readerSchema.type()) {
            case BIT: {
                return new ColumnConverter.ScalarColumnConverter(value -> writer.setBoolean(((Boolean)value).booleanValue()));
            }
        }
        return super.buildScalar(readerSchema, writer);
    }

    protected ColumnConverter getMapConverter(TupleMetadata providedSchema, TupleMetadata readerSchema, TupleWriter tupleWriter) {
        Map<String, ColumnConverter> converters = StreamSupport.stream(readerSchema.spliterator(), false).collect(Collectors.toMap(ColumnMetadata::name, columnMetadata -> this.getConverter(providedSchema, (ColumnMetadata)columnMetadata, tupleWriter.column(columnMetadata.name()))));
        return new ElasticMapColumnConverter(this, providedSchema, tupleWriter, converters);
    }

    private static class ElasticMapColumnConverter
    extends ColumnConverter.MapColumnConverter {
        public ElasticMapColumnConverter(ColumnConverterFactory factory, TupleMetadata providedSchema, TupleWriter tupleWriter, Map<String, ColumnConverter> converters) {
            super(factory, providedSchema, tupleWriter, converters);
        }
    }
}

