/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.elasticsearch.plan;

import org.apache.calcite.adapter.elasticsearch.CalciteUtils;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchFilter;
import org.apache.calcite.adapter.elasticsearch.ElasticsearchRel;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.drill.exec.store.elasticsearch.plan.NodeTypeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchFilterRule
extends ConverterRule {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchFilterRule.class);
    public static final ElasticsearchFilterRule INSTANCE = new ElasticsearchFilterRule();
    private final Convention out = ElasticsearchRel.CONVENTION;

    private ElasticsearchFilterRule() {
        super(ConverterRule.Config.INSTANCE.withConversion(Filter.class, (RelTrait)Convention.NONE, (RelTrait)ElasticsearchRel.CONVENTION, "DrillElasticsearchFilterRule"));
    }

    public RelNode convert(RelNode relNode) {
        Filter filter = (Filter)relNode;
        NodeTypeFinder filterFinder = new NodeTypeFinder(ElasticsearchFilter.class);
        filter.getInput().accept((RelShuttle)filterFinder);
        if (filterFinder.containsNode) {
            return null;
        }
        RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
        try {
            CalciteUtils.analyzePredicate(filter.getCondition());
        }
        catch (Exception e) {
            logger.info("Unable to push filter into ElasticSearch :{}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        return CalciteUtils.createFilter(traitSet, ElasticsearchFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.out), filter.getCondition());
    }
}

