/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.ErrorCollector;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.visitors.ExpressionValidationError;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.collect.Range;
import org.slf4j.Logger;

public class ErrorCollectorImpl
implements ErrorCollector {
    private final List<ExpressionValidationError> errors = new ArrayList<ExpressionValidationError>();

    private String addExpr(ExpressionPosition expr, String message) {
        return String.format("Error in expression at index %d.  Error: %s. Full expression: %s.", expr.getCharIndex(), message, expr.getExpression());
    }

    @Override
    public void addGeneralError(ExpressionPosition expr, String s) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, s)));
    }

    @Override
    public void addUnexpectedArgumentType(ExpressionPosition expr, String name, TypeProtos.MajorType actual, TypeProtos.MajorType[] expected, int argumentIndex) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, String.format("Unexpected argument type. Index :%d Name: %s, Type: %s, Expected type(s): %s", argumentIndex, name, actual, Arrays.toString(expected)))));
    }

    @Override
    public void addUnexpectedArgumentCount(ExpressionPosition expr, int actual, Range<Integer> expected) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, String.format("Unexpected argument count. Actual argument count: %d, Expected range: %s", actual, expected))));
    }

    @Override
    public void addUnexpectedArgumentCount(ExpressionPosition expr, int actual, int expected) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, String.format("Unexpected argument count. Actual argument count: %d, Expected count: %d", actual, expected))));
    }

    @Override
    public void addNonNumericType(ExpressionPosition expr, TypeProtos.MajorType actual) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, String.format("Unexpected numeric type. Actual type: %s", actual))));
    }

    @Override
    public void addUnexpectedType(ExpressionPosition expr, int index, TypeProtos.MajorType actual) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, String.format("Unexpected argument type. Actual type: %s, Index: %d", actual, index))));
    }

    @Override
    public void addExpectedConstantValue(ExpressionPosition expr, int actual, String s) {
        this.errors.add(new ExpressionValidationError(this.addExpr(expr, String.format("Unexpected constant value. Name: %s, Actual: %s", s, actual))));
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public int getErrorCount() {
        return this.errors.size();
    }

    @Override
    public String toErrorString() {
        return "\n" + Joiner.on((String)"\n").join(this.errors);
    }

    public String toString() {
        return this.toErrorString();
    }

    @Override
    public void reportErrors(Logger logger) {
        if (!this.hasErrors()) {
            return;
        }
        throw UserException.internalError(null).message("Failure while materializing expression.", new Object[0]).addContext("Errors", this.toErrorString()).build(logger);
    }
}

