/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.iceberg.IcebergGroupScan;
import org.apache.drill.exec.store.iceberg.IcebergWork;
import org.apache.drill.exec.store.iceberg.format.IcebergFormatPlugin;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.iceberg.TableScan;

@JsonTypeName(value="iceberg-read")
public class IcebergSubScan
extends AbstractBase
implements SubScan {
    private static final String OPERATOR_TYPE = "ICEBERG_SUB_SCAN";
    private final IcebergFormatPlugin formatPlugin;
    private final List<SchemaPath> columns;
    private final LogicalExpression condition;
    private final TupleMetadata schema;
    private final List<IcebergWork> workList;
    private final TableScan tableScan;
    private final String path;
    private final int maxRecords;

    @JsonCreator
    public IcebergSubScan(@JsonProperty(value="userName") String userName, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="path") String path, @JsonProperty(value="workList") List<IcebergWork> workList, @JsonProperty(value="schema") TupleMetadata schema, @JsonProperty(value="condition") LogicalExpression condition, @JsonProperty(value="maxRecords") Integer maxRecords, @JacksonInject StoragePluginRegistry pluginRegistry) {
        this.formatPlugin = (IcebergFormatPlugin)pluginRegistry.resolveFormat(storageConfig, formatConfig, IcebergFormatPlugin.class);
        this.columns = columns;
        this.workList = workList;
        this.path = path;
        this.condition = condition;
        this.tableScan = this.getTableScan(columns, path, condition);
        this.schema = schema;
        this.maxRecords = maxRecords;
    }

    private IcebergSubScan(IcebergSubScanBuilder builder) {
        super(builder.userName);
        this.formatPlugin = builder.formatPlugin;
        this.columns = builder.columns;
        this.condition = builder.condition;
        this.schema = builder.schema;
        this.workList = builder.workList;
        this.tableScan = builder.tableScan;
        this.path = builder.path;
        this.maxRecords = builder.maxRecords;
    }

    public static IcebergSubScanBuilder builder() {
        return new IcebergSubScanBuilder();
    }

    private TableScan getTableScan(List<SchemaPath> columns, String path, LogicalExpression condition) {
        return IcebergGroupScan.projectColumns(IcebergGroupScan.initTableScan(this.formatPlugin, path, condition), columns);
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public List<IcebergWork> getWorkList() {
        return this.workList;
    }

    @JsonIgnore
    public TableScan getTableScan() {
        return this.tableScan;
    }

    public int getMaxRecords() {
        return this.maxRecords;
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public LogicalExpression getCondition() {
        return this.condition;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return this.toBuilder().build();
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="format")
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    public String getPath() {
        return this.path;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    public TupleMetadata getSchema() {
        return this.schema;
    }

    public IcebergSubScanBuilder toBuilder() {
        return new IcebergSubScanBuilder().userName(this.userName).formatPlugin(this.formatPlugin).columns(this.columns).condition(this.condition).schema(this.schema).workList(this.workList).tableScan(this.tableScan).path(this.path).maxRecords(this.maxRecords);
    }

    public static class IcebergSubScanBuilder {
        private String userName;
        private IcebergFormatPlugin formatPlugin;
        private List<SchemaPath> columns;
        private LogicalExpression condition;
        private TupleMetadata schema;
        private List<IcebergWork> workList;
        private TableScan tableScan;
        private String path;
        private int maxRecords;

        public IcebergSubScanBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public IcebergSubScanBuilder formatPlugin(IcebergFormatPlugin formatPlugin) {
            this.formatPlugin = formatPlugin;
            return this;
        }

        public IcebergSubScanBuilder columns(List<SchemaPath> columns) {
            this.columns = columns;
            return this;
        }

        public IcebergSubScanBuilder condition(LogicalExpression condition) {
            this.condition = condition;
            return this;
        }

        public IcebergSubScanBuilder schema(TupleMetadata schema) {
            this.schema = schema;
            return this;
        }

        public IcebergSubScanBuilder workList(List<IcebergWork> workList) {
            this.workList = workList;
            return this;
        }

        public IcebergSubScanBuilder tableScan(TableScan tableScan) {
            this.tableScan = tableScan;
            return this;
        }

        public IcebergSubScanBuilder path(String path) {
            this.path = path;
            return this;
        }

        public IcebergSubScanBuilder maxRecords(int maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public IcebergSubScan build() {
            return new IcebergSubScan(this);
        }
    }
}

