/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.iceberg.plan;

import java.math.BigDecimal;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.exec.store.iceberg.IcebergGroupScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class DrillExprToIcebergTranslator
extends AbstractExprVisitor<Expression, Void, RuntimeException> {
    public static final ExprVisitor<Expression, Void, RuntimeException> INSTANCE = new DrillExprToIcebergTranslator();

    public Expression visitFunctionCall(FunctionCall call, Void value) throws RuntimeException {
        switch (call.getName()) {
            case "booleanAnd": {
                Expression left = (Expression)call.arg(0).accept((ExprVisitor)this, null);
                Expression right = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (left != null && right != null) {
                    return Expressions.and((Expression)left, (Expression)right);
                }
                return null;
            }
            case "booleanOr": {
                Expression left = (Expression)call.arg(0).accept((ExprVisitor)this, null);
                Expression right = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (left != null && right != null) {
                    return Expressions.or((Expression)left, (Expression)right);
                }
                return null;
            }
            case "not": {
                Expression expression = (Expression)call.arg(0).accept((ExprVisitor)this, null);
                if (expression != null) {
                    return Expressions.not((Expression)expression);
                }
                return null;
            }
            case "isnull": {
                LogicalExpression arg = call.arg(0);
                if (arg instanceof SchemaPath) {
                    String name = IcebergGroupScan.getPath((SchemaPath)arg);
                    return Expressions.isNull((String)name);
                }
                return null;
            }
            case "isnotnull": {
                LogicalExpression arg = call.arg(0);
                if (arg instanceof SchemaPath) {
                    String name = IcebergGroupScan.getPath((SchemaPath)arg);
                    return Expressions.notNull((String)name);
                }
                return null;
            }
            case "less_than": {
                LogicalExpression nameRef = call.arg(0);
                Expression expression = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath && expression instanceof ConstantExpression) {
                    String name = IcebergGroupScan.getPath((SchemaPath)nameRef);
                    return Expressions.lessThan((String)name, ((ConstantExpression)expression).getValue());
                }
                return null;
            }
            case "less_than_or_equal_to": {
                LogicalExpression nameRef = call.arg(0);
                Expression expression = (Expression)call.arg(1).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath && expression instanceof ConstantExpression) {
                    String name = IcebergGroupScan.getPath((SchemaPath)nameRef);
                    return Expressions.lessThanOrEqual((String)name, ((ConstantExpression)expression).getValue());
                }
                return null;
            }
            case "greater_than": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(1)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath && expression instanceof ConstantExpression) {
                    String name = IcebergGroupScan.getPath((SchemaPath)nameRef);
                    return Expressions.greaterThan((String)name, ((ConstantExpression)expression).getValue());
                }
                return null;
            }
            case "greater_than_or_equal_to": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(0)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath && expression instanceof ConstantExpression) {
                    String name = IcebergGroupScan.getPath((SchemaPath)nameRef);
                    return Expressions.greaterThanOrEqual((String)name, ((ConstantExpression)expression).getValue());
                }
                return null;
            }
            case "equal": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(1)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath && expression instanceof ConstantExpression) {
                    String name = IcebergGroupScan.getPath((SchemaPath)nameRef);
                    return Expressions.equal((String)name, ((ConstantExpression)expression).getValue());
                }
                return null;
            }
            case "not_equal": {
                LogicalExpression nameRef = (LogicalExpression)call.args().get(0);
                Expression expression = (Expression)((LogicalExpression)call.args().get(1)).accept((ExprVisitor)this, null);
                if (nameRef instanceof SchemaPath && expression instanceof ConstantExpression) {
                    String name = IcebergGroupScan.getPath((SchemaPath)nameRef);
                    return Expressions.notEqual((String)name, ((ConstantExpression)expression).getValue());
                }
                return null;
            }
        }
        return null;
    }

    public Expression visitFloatConstant(ValueExpressions.FloatExpression fExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Float>(Float.valueOf(fExpr.getFloat()));
    }

    public Expression visitIntConstant(ValueExpressions.IntExpression intExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Integer>(intExpr.getInt());
    }

    public Expression visitLongConstant(ValueExpressions.LongExpression longExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Long>(longExpr.getLong());
    }

    public Expression visitDecimal9Constant(ValueExpressions.Decimal9Expression decExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Integer>(decExpr.getIntFromDecimal());
    }

    public Expression visitDecimal18Constant(ValueExpressions.Decimal18Expression decExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Long>(decExpr.getLongFromDecimal());
    }

    public Expression visitDecimal28Constant(ValueExpressions.Decimal28Expression decExpr, Void value) throws RuntimeException {
        return new ConstantExpression<BigDecimal>(decExpr.getBigDecimal());
    }

    public Expression visitDecimal38Constant(ValueExpressions.Decimal38Expression decExpr, Void value) throws RuntimeException {
        return new ConstantExpression<BigDecimal>(decExpr.getBigDecimal());
    }

    public Expression visitVarDecimalConstant(ValueExpressions.VarDecimalExpression decExpr, Void value) throws RuntimeException {
        return new ConstantExpression<BigDecimal>(decExpr.getBigDecimal());
    }

    public Expression visitDateConstant(ValueExpressions.DateExpression dateExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Long>(dateExpr.getDate());
    }

    public Expression visitTimeConstant(ValueExpressions.TimeExpression timeExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Integer>(timeExpr.getTime());
    }

    public Expression visitTimeStampConstant(ValueExpressions.TimeStampExpression timestampExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Long>(timestampExpr.getTimeStamp());
    }

    public Expression visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, Void value) throws RuntimeException {
        return new ConstantExpression<Double>(dExpr.getDouble());
    }

    public Expression visitBooleanConstant(ValueExpressions.BooleanExpression e, Void value) throws RuntimeException {
        return new ConstantExpression<Boolean>(e.getBoolean());
    }

    public Expression visitQuotedStringConstant(ValueExpressions.QuotedString e, Void value) throws RuntimeException {
        return new ConstantExpression<String>(e.getString());
    }

    public Expression visitUnknown(LogicalExpression e, Void value) throws RuntimeException {
        return null;
    }

    private static class ConstantExpression<T>
    implements Expression {
        private final T value;

        public ConstantExpression(T value) {
            this.value = value;
        }

        public Expression.Operation op() {
            return null;
        }

        public T getValue() {
            return this.value;
        }
    }
}

