/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.kafka.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.kafka.KafkaScanSpec;
import org.apache.drill.exec.store.kafka.KafkaStoragePlugin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageSchema
extends AbstractSchema {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageSchema.class);
    private final KafkaStoragePlugin plugin;
    private final Map<String, DrillTable> drillTables = new HashMap<String, DrillTable>();
    private Set<String> tableNames;

    public KafkaMessageSchema(KafkaStoragePlugin plugin, String name) {
        super(Collections.emptyList(), name);
        this.plugin = plugin;
    }

    public String getTypeName() {
        return "kafka";
    }

    void setHolder(SchemaPlus plusOfThis) {
        for (String s : this.getSubSchemaNames()) {
            plusOfThis.add(s, this.getSubSchema(s));
        }
    }

    public Table getTable(String tableName) {
        if (!this.drillTables.containsKey(tableName)) {
            KafkaScanSpec scanSpec = new KafkaScanSpec(tableName);
            DynamicDrillTable table = new DynamicDrillTable((StoragePlugin)this.plugin, this.getName(), (DrillTableSelection)scanSpec);
            this.drillTables.put(tableName, (DrillTable)table);
        }
        return (Table)this.drillTables.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getTableNames() {
        if (this.tableNames == null) {
            KafkaConsumer kafkaConsumer = null;
            try {
                kafkaConsumer = new KafkaConsumer(this.plugin.getConfig().getKafkaConsumerProps());
                this.tableNames = kafkaConsumer.listTopics().keySet();
                this.plugin.registerToClose((AutoCloseable)kafkaConsumer);
            }
            catch (Exception e) {
                try {
                    logger.warn("Failure while loading table names for database '{}': {}", new Object[]{this.getName(), e.getMessage(), e.getCause()});
                    Set<String> set = Collections.emptySet();
                    this.plugin.registerToClose((AutoCloseable)kafkaConsumer);
                    return set;
                }
                catch (Throwable throwable) {
                    this.plugin.registerToClose((AutoCloseable)kafkaConsumer);
                    throw throwable;
                }
            }
        }
        return this.tableNames;
    }
}

