/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors.nginxmodules;

import java.util.ArrayList;
import java.util.List;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.httpdlog.dissectors.nginxmodules.NginxModule;
import nl.basjes.parse.httpdlog.dissectors.tokenformat.TokenParser;

public class SslModule
implements NginxModule {
    private static final String PREFIX = "nginxmodule.ssl";

    @Override
    public List<TokenParser> getTokenParsers() {
        ArrayList<TokenParser> parsers = new ArrayList<TokenParser>(60);
        parsers.add(new TokenParser("$ssl_cipher", "nginxmodule.ssl.cipher", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_ciphers", "nginxmodule.ssl.client.ciphers", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_escaped_cert", "nginxmodule.ssl.client.cert", "PEM_CERT_URLENCODED", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$ssl_client_cert", "nginxmodule.ssl.client.cert", "PEM_CERT", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_raw_cert", "nginxmodule.ssl.client.cert", "PEM_CERT_RAW", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_fingerprint", "nginxmodule.ssl.client.cert.fingerprint", "SHA1", Casts.STRING_ONLY, "[^\\s]*"));
        parsers.add(new TokenParser("$ssl_client_i_dn", "nginxmodule.ssl.client.cert.issuer_dn", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_i_dn_legacy", "nginxmodule.ssl.client.cert.issuer_dn.legacy", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_s_dn", "nginxmodule.ssl.client.cert.subject_dn", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_s_dn_legacy", "nginxmodule.ssl.client.cert.subject_dn.legacy", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_serial", "nginxmodule.ssl.client.cert.serial", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_v_end", "nginxmodule.ssl.client.cert.end_date", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_v_remain", "nginxmodule.ssl.client.cert.remain_days", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_v_start", "nginxmodule.ssl.client.cert.start_date", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_client_verify", "nginxmodule.ssl.client.cert.verify", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_curves", "nginxmodule.ssl.client.curves", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_early_data", "nginxmodule.ssl.early_data", "STRING", Casts.STRING_ONLY, "1?"));
        parsers.add(new TokenParser("$ssl_protocol", "nginxmodule.ssl.protocol", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_server_name", "nginxmodule.ssl.server_name", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_session_id", "nginxmodule.ssl.session.id", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_session_reused", "nginxmodule.ssl.session.reused", "STRING", Casts.STRING_ONLY, "(r|.)"));
        parsers.add(new TokenParser("$ssl_preread_protocol", "nginxmodule.ssl.preread.protocol", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_preread_server_name", "nginxmodule.ssl.preread.server_name", "STRING", Casts.STRING_ONLY, ".*?"));
        parsers.add(new TokenParser("$ssl_preread_alpn_protocols", "nginxmodule.ssl.preread.alpn_protocols", "STRING", Casts.STRING_ONLY, ".*?"));
        return parsers;
    }
}

