/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula.detectors;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.rendering.ImageType;
import technology.tabula.Cell;
import technology.tabula.Line;
import technology.tabula.Page;
import technology.tabula.Rectangle;
import technology.tabula.Ruling;
import technology.tabula.TextChunk;
import technology.tabula.TextElement;
import technology.tabula.Utils;
import technology.tabula.detectors.DetectionAlgorithm;
import technology.tabula.extractors.SpreadsheetExtractionAlgorithm;

public class NurminenDetectionAlgorithm
implements DetectionAlgorithm {
    private static final int GRAYSCALE_INTENSITY_THRESHOLD = 25;
    private static final int HORIZONTAL_EDGE_WIDTH_MINIMUM = 50;
    private static final int VERTICAL_EDGE_HEIGHT_MINIMUM = 10;
    private static final int CELL_CORNER_DISTANCE_MAXIMUM = 10;
    private static final float POINT_SNAP_DISTANCE_THRESHOLD = 8.0f;
    private static final float TABLE_PADDING_AMOUNT = 1.0f;
    private static final int REQUIRED_TEXT_LINES_FOR_EDGE = 4;
    private static final int REQUIRED_CELLS_FOR_TABLE = 4;
    private static final float IDENTICAL_TABLE_OVERLAP_RATIO = 0.9f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Rectangle> detect(Page page) {
        boolean foundTable;
        Iterator<Object> iterator;
        BufferedImage image;
        PDPage pdfPage = page.getPDPage();
        try {
            image = Utils.pageConvertToImage(page.getPDDoc(), pdfPage, 144, ImageType.GRAY);
        }
        catch (IOException e) {
            return new ArrayList<Rectangle>();
        }
        List<Ruling> horizontalRulings = this.getHorizontalRulings(image);
        PDDocument removeTextDocument = null;
        try {
            removeTextDocument = this.removeText(pdfPage);
            pdfPage = removeTextDocument.getPage(0);
            image = Utils.pageConvertToImage(removeTextDocument, pdfPage, 144, ImageType.GRAY);
        }
        catch (Exception e) {
            ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
            return arrayList;
        }
        finally {
            if (removeTextDocument != null) {
                try {
                    removeTextDocument.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        List<Ruling> verticalRulings = this.getVerticalRulings(image);
        ArrayList<Ruling> allEdges = new ArrayList<Ruling>(horizontalRulings);
        allEdges.addAll(verticalRulings);
        List<Object> tableAreas = new ArrayList();
        if (allEdges.size() > 0) {
            Utils.snapPoints(allEdges, 8.0f, 8.0f);
            for (List list : Arrays.asList(horizontalRulings, verticalRulings)) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    Ruling ruling = (Ruling)iterator.next();
                    ruling.normalize();
                    if (!ruling.oblique()) continue;
                    iterator.remove();
                }
            }
            horizontalRulings = Ruling.collapseOrientedRulings(horizontalRulings, 5);
            verticalRulings = Ruling.collapseOrientedRulings(verticalRulings, 5);
            List<Cell> cells = SpreadsheetExtractionAlgorithm.findCells(horizontalRulings, verticalRulings);
            tableAreas = this.getTableAreasFromCells((List<? extends Rectangle>)cells);
        }
        block20: for (Line2D.Float float_ : verticalRulings) {
            for (Rectangle rectangle : tableAreas) {
                if (!float_.intersects(rectangle) || rectangle.contains(float_.getP1()) && rectangle.contains(float_.getP2())) continue;
                rectangle.setTop((float)Math.floor(Math.min((double)rectangle.getTop(), float_.getY1())));
                rectangle.setBottom((float)Math.ceil(Math.max((double)rectangle.getBottom(), float_.getY2())));
                continue block20;
            }
        }
        for (Rectangle rectangle : tableAreas) {
            rectangle.x = (float)Math.floor(rectangle.x / 2.0f) - 1.0f;
            rectangle.y = (float)Math.floor(rectangle.y / 2.0f) - 1.0f;
            rectangle.width = (float)Math.ceil(rectangle.width / 2.0f) + 1.0f;
            rectangle.height = (float)Math.ceil(rectangle.height / 2.0f) + 1.0f;
        }
        for (Line2D.Float float_ : horizontalRulings) {
            float_.x1 /= 2.0f;
            float_.y1 /= 2.0f;
            float_.x2 /= 2.0f;
            float_.y2 /= 2.0f;
        }
        List<TextChunk> textChunks = TextElement.mergeWords(page.getText());
        List<Line> list = TextChunk.groupByLines(textChunks);
        for (Line line : list) {
            for (Object tableArea : tableAreas) {
                if (((RectangularShape)tableArea).contains(line) || !line.intersects((Rectangle2D)tableArea)) continue;
                ((Rectangle)tableArea).setLeft((float)Math.floor(Math.min(line.getLeft(), ((Rectangle)tableArea).getLeft())));
                ((Rectangle)tableArea).setRight((float)Math.ceil(Math.max(line.getRight(), ((Rectangle)tableArea).getRight())));
            }
        }
        iterator = tableAreas.iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle = (Rectangle)iterator.next();
            boolean intersectsText = false;
            for (Line line : list) {
                if (!rectangle.intersects(line)) continue;
                intersectsText = true;
                break;
            }
            if (intersectsText) continue;
            iterator.remove();
        }
        do {
            foundTable = false;
            Iterator<Line> iterator2 = list.iterator();
            block29: while (iterator2.hasNext()) {
                Line textRow = iterator2.next();
                for (Rectangle rectangle : tableAreas) {
                    if (!rectangle.contains(textRow)) continue;
                    iterator2.remove();
                    continue block29;
                }
            }
            TextEdges textEdges = this.getTextEdges(list);
            List leftTextEdges = (List)textEdges.get(0);
            List midTextEdges = (List)textEdges.get(1);
            List list2 = (List)textEdges.get(2);
            RelevantEdges relevantEdgeInfo = this.getRelevantEdges(textEdges, list);
            if (relevantEdgeInfo.edgeType == -1) continue;
            List relevantEdges = null;
            switch (relevantEdgeInfo.edgeType) {
                case 0: {
                    relevantEdges = leftTextEdges;
                    break;
                }
                case 1: {
                    relevantEdges = midTextEdges;
                    break;
                }
                case 2: {
                    relevantEdges = list2;
                }
            }
            Rectangle table = this.getTableFromText(list, relevantEdges, relevantEdgeInfo.edgeCount, horizontalRulings);
            if (table == null) continue;
            foundTable = true;
            tableAreas.add(table);
        } while (foundTable);
        TreeSet<Rectangle> treeSet = new TreeSet<Rectangle>(new Comparator<Rectangle>(){

            @Override
            public int compare(Rectangle o1, Rectangle o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o2.contains(o1)) {
                    return 0;
                }
                if (o1.contains(o2)) {
                    return 0;
                }
                float overlap = o1.overlapRatio(o2);
                if (overlap >= 0.9f) {
                    return 0;
                }
                return 1;
            }
        });
        treeSet.addAll(tableAreas);
        return new ArrayList<Rectangle>(treeSet);
    }

    private Rectangle getTableFromText(List<Line> lines, List<TextEdge> relevantEdges, int relevantEdgeCount, List<Ruling> horizontalRulings) {
        float distanceFromTable;
        Rectangle table = new Rectangle();
        Rectangle prevRow = null;
        Line firstTableRow = null;
        Rectangle lastTableRow = null;
        int tableSpaceCount = 0;
        float totalRowSpacing = 0.0f;
        for (Line textRow : lines) {
            int n;
            int numRelevantEdges = 0;
            if (firstTableRow != null && tableSpaceCount > 0) {
                float f = totalRowSpacing / (float)tableSpaceCount * 2.5f;
                float lineDistance = textRow.getTop() - prevRow.getTop();
                if (lineDistance > f) {
                    lastTableRow = prevRow;
                    break;
                }
            }
            boolean bl = true;
            if (relevantEdgeCount <= 3) {
                n = 0;
            }
            for (TextEdge edge : relevantEdges) {
                if (!textRow.intersectsLine(edge)) continue;
                ++numRelevantEdges;
            }
            if (numRelevantEdges >= relevantEdgeCount - n) {
                if (prevRow != null && firstTableRow != null) {
                    ++tableSpaceCount;
                    totalRowSpacing += textRow.getTop() - prevRow.getTop();
                }
                if (table.getArea() == 0.0f) {
                    firstTableRow = textRow;
                    table.setRect(textRow);
                } else {
                    table.setLeft(Math.min(table.getLeft(), textRow.getLeft()));
                    table.setBottom(Math.max(table.getBottom(), textRow.getBottom()));
                    table.setRight(Math.max(table.getRight(), textRow.getRight()));
                }
            } else if (firstTableRow != null && lastTableRow == null) {
                lastTableRow = prevRow;
            }
            prevRow = textRow;
        }
        if (table.getArea() == 0.0f) {
            return null;
        }
        if (lastTableRow == null) {
            lastTableRow = prevRow;
        }
        float avgRowHeight = tableSpaceCount > 0 ? totalRowSpacing / (float)tableSpaceCount : ((Line)lastTableRow).height;
        float rowHeightThreshold = avgRowHeight * 1.5f;
        for (Line2D.Float float_ : horizontalRulings) {
            if (float_.getY1() < (double)table.getBottom()) continue;
            distanceFromTable = (float)float_.getY1() - table.getBottom();
            if (!(distanceFromTable <= rowHeightThreshold)) break;
            table.setBottom((float)Math.max((double)table.getBottom(), float_.getY1()));
            table.setLeft((float)Math.min((double)table.getLeft(), float_.getX1()));
            table.setRight((float)Math.max((double)table.getRight(), float_.getX2()));
        }
        rowHeightThreshold = avgRowHeight * 3.8f;
        for (int i = horizontalRulings.size() - 1; i >= 0; --i) {
            Line2D.Float float_ = horizontalRulings.get(i);
            if (float_.getY1() > (double)table.getTop()) continue;
            distanceFromTable = table.getTop() - (float)float_.getY1();
            if (!(distanceFromTable <= rowHeightThreshold)) break;
            table.setTop((float)Math.min((double)table.getTop(), float_.getY1()));
            table.setLeft((float)Math.min((double)table.getLeft(), float_.getX1()));
            table.setRight((float)Math.max((double)table.getRight(), float_.getX2()));
        }
        table.setTop((float)Math.floor(table.getTop()) - 1.0f);
        table.setBottom((float)Math.ceil(table.getBottom()) + 1.0f);
        table.setLeft((float)Math.floor(table.getLeft()) - 1.0f);
        table.setRight((float)Math.ceil(table.getRight()) + 1.0f);
        return table;
    }

    private RelevantEdges getRelevantEdges(TextEdges textEdges, List<Line> lines) {
        List leftTextEdges = (List)textEdges.get(0);
        List midTextEdges = (List)textEdges.get(1);
        List rightTextEdges = (List)textEdges.get(2);
        int[][] edgeCountsPerLine = new int[lines.size()][3];
        for (TextEdge edge : leftTextEdges) {
            int[] nArray = edgeCountsPerLine[edge.intersectingTextRowCount - 1];
            nArray[0] = nArray[0] + 1;
        }
        for (TextEdge edge : midTextEdges) {
            int[] nArray = edgeCountsPerLine[edge.intersectingTextRowCount - 1];
            nArray[1] = nArray[1] + 1;
        }
        for (TextEdge edge : rightTextEdges) {
            int[] nArray = edgeCountsPerLine[edge.intersectingTextRowCount - 1];
            nArray[2] = nArray[2] + 1;
        }
        int relevantEdgeType = -1;
        int relevantEdgeCount = 0;
        for (int i = edgeCountsPerLine.length - 1; i > 2; --i) {
            if (edgeCountsPerLine[i][0] > 2 && edgeCountsPerLine[i][0] >= edgeCountsPerLine[i][2] && edgeCountsPerLine[i][0] >= edgeCountsPerLine[i][1]) {
                relevantEdgeCount = edgeCountsPerLine[i][0];
                relevantEdgeType = 0;
                break;
            }
            if (edgeCountsPerLine[i][2] > 1 && edgeCountsPerLine[i][2] >= edgeCountsPerLine[i][0] && edgeCountsPerLine[i][2] >= edgeCountsPerLine[i][1]) {
                relevantEdgeCount = edgeCountsPerLine[i][2];
                relevantEdgeType = 2;
                break;
            }
            if (edgeCountsPerLine[i][1] <= 1 || edgeCountsPerLine[i][1] < edgeCountsPerLine[i][2] || edgeCountsPerLine[i][1] < edgeCountsPerLine[i][0]) continue;
            relevantEdgeCount = edgeCountsPerLine[i][1];
            relevantEdgeType = 1;
            break;
        }
        return new RelevantEdges(relevantEdgeType, relevantEdgeCount);
    }

    private TextEdges getTextEdges(List<Line> lines) {
        ArrayList<TextEdge> leftTextEdges = new ArrayList<TextEdge>();
        ArrayList<TextEdge> midTextEdges = new ArrayList<TextEdge>();
        ArrayList<TextEdge> rightTextEdges = new ArrayList<TextEdge>();
        HashMap<Integer, List<TextChunk>> currLeftEdges = new HashMap<Integer, List<TextChunk>>();
        HashMap<Integer, List<TextChunk>> currMidEdges = new HashMap<Integer, List<TextChunk>>();
        HashMap<Integer, List<TextChunk>> currRightEdges = new HashMap<Integer, List<TextChunk>>();
        int numOfLines = lines.size();
        for (Line textRow : lines) {
            for (TextChunk text : textRow.getTextElements()) {
                Integer left = (int)Math.floor(text.getLeft());
                Integer right = (int)Math.floor(text.getRight());
                Integer mid = left + (right - left) / 2;
                List leftEdge = currLeftEdges.computeIfAbsent(left, k -> new ArrayList());
                leftEdge.add(text);
                List midEdge = currMidEdges.computeIfAbsent(mid, k -> new ArrayList());
                midEdge.add(text);
                List rightEdge = currRightEdges.computeIfAbsent(right, k -> new ArrayList());
                rightEdge.add(text);
                leftTextEdges.addAll(this.calculateExtendedEdges(numOfLines, currLeftEdges, left, right));
                midTextEdges.addAll(this.calculateExtendedEdges(numOfLines, currMidEdges, left, right, mid, 2));
                rightTextEdges.addAll(this.calculateExtendedEdges(numOfLines, currRightEdges, left, right));
            }
        }
        leftTextEdges.addAll(this.calculateLeftoverEdges(numOfLines, currLeftEdges));
        midTextEdges.addAll(this.calculateLeftoverEdges(numOfLines, currMidEdges));
        rightTextEdges.addAll(this.calculateLeftoverEdges(numOfLines, currRightEdges));
        return new TextEdges(leftTextEdges, midTextEdges, rightTextEdges);
    }

    private Set<TextEdge> calculateLeftoverEdges(int numOfLines, Map<Integer, List<TextChunk>> currDirectedEdges) {
        HashSet<TextEdge> leftoverEdges = new HashSet<TextEdge>();
        for (Integer key : currDirectedEdges.keySet()) {
            List<TextChunk> edgeChunks = currDirectedEdges.get(key);
            if (edgeChunks.size() < 4) continue;
            TextEdge edge = this.getEdgeFromChunks(numOfLines, key, edgeChunks);
            leftoverEdges.add(edge);
        }
        return leftoverEdges;
    }

    private TextEdge getEdgeFromChunks(int numOfLines, Integer key, List<TextChunk> edgeChunks) {
        TextChunk first = edgeChunks.get(0);
        TextChunk last = edgeChunks.get(edgeChunks.size() - 1);
        TextEdge edge = new TextEdge(key.intValue(), first.getTop(), key.intValue(), last.getBottom());
        edge.intersectingTextRowCount = Math.min(edgeChunks.size(), numOfLines);
        return edge;
    }

    private Collection<TextEdge> calculateExtendedEdges(Integer numOfLines, Map<Integer, List<TextChunk>> currDirectedEdges, Integer left, Integer right) {
        return this.calculateExtendedEdges(numOfLines, currDirectedEdges, left, right, null, null);
    }

    private Collection<TextEdge> calculateExtendedEdges(Integer numOfLines, Map<Integer, List<TextChunk>> currDirectedEdges, Integer left, Integer right, Integer mid, Integer minDistToMid) {
        HashSet<TextEdge> extendedEdges = new HashSet<TextEdge>();
        Iterator<Map.Entry<Integer, List<TextChunk>>> edgeIterator = currDirectedEdges.entrySet().iterator();
        while (edgeIterator.hasNext()) {
            boolean hasMinDistToMid;
            Map.Entry<Integer, List<TextChunk>> entry = edgeIterator.next();
            Integer key = entry.getKey();
            boolean bl = hasMinDistToMid = mid == null || minDistToMid == null || Math.abs(key - mid) > minDistToMid;
            if (key <= left || key >= right || !hasMinDistToMid) continue;
            edgeIterator.remove();
            List<TextChunk> edgeChunks = entry.getValue();
            if (edgeChunks.size() < 4) continue;
            TextEdge edge = this.getEdgeFromChunks(numOfLines, key, edgeChunks);
            extendedEdges.add(edge);
        }
        return extendedEdges;
    }

    private List<Rectangle> getTableAreasFromCells(List<? extends Rectangle> cells) {
        ArrayList cellGroups = new ArrayList();
        for (Rectangle rectangle : cells) {
            boolean bl = false;
            block1: for (List list : cellGroups) {
                for (Rectangle groupCell : list) {
                    Point2D[] candidateCorners;
                    Point2D[] groupCellCorners = groupCell.getPoints();
                    for (Point2D candidateCorner : candidateCorners = rectangle.getPoints()) {
                        for (Point2D groupCellCorner : groupCellCorners) {
                            if (!(candidateCorner.distance(groupCellCorner) < 10.0)) continue;
                            list.add(rectangle);
                            bl = true;
                            break block1;
                        }
                    }
                }
            }
            if (bl) continue;
            ArrayList<Rectangle> cellGroup = new ArrayList<Rectangle>();
            cellGroup.add(rectangle);
            cellGroups.add(cellGroup);
        }
        ArrayList<Rectangle> tableAreas = new ArrayList<Rectangle>();
        for (List list : cellGroups) {
            if (list.size() < 4) continue;
            float top = Float.MAX_VALUE;
            float f = Float.MAX_VALUE;
            float bottom = Float.MIN_VALUE;
            float right = Float.MIN_VALUE;
            for (Rectangle cell : list) {
                if (cell.getTop() < top) {
                    top = cell.getTop();
                }
                if (cell.getLeft() < f) {
                    f = cell.getLeft();
                }
                if (cell.getBottom() > bottom) {
                    bottom = cell.getBottom();
                }
                if (!(cell.getRight() > right)) continue;
                right = cell.getRight();
            }
            tableAreas.add(new Rectangle(top, f, right - f, bottom - top));
        }
        return tableAreas;
    }

    private List<Ruling> getHorizontalRulings(BufferedImage image) {
        ArrayList<Ruling> horizontalRulings = new ArrayList<Ruling>();
        WritableRaster r = image.getRaster();
        int width = r.getWidth();
        int height = r.getHeight();
        for (int x = 0; x < width; ++x) {
            int[] lastPixel = r.getPixel(x, 0, (int[])null);
            for (int y = 1; y < height - 1; ++y) {
                int[] currPixel = r.getPixel(x, y, (int[])null);
                int diff = Math.abs(currPixel[0] - lastPixel[0]);
                if (diff > 25) {
                    int[] abovePixel;
                    int[] nArray;
                    int lineX;
                    boolean alreadyChecked = false;
                    for (Line2D.Float float_ : horizontalRulings) {
                        if ((double)y != float_.getY1() || !((double)x >= float_.getX1()) || !((double)x <= float_.getX2())) continue;
                        alreadyChecked = true;
                        break;
                    }
                    if (alreadyChecked) {
                        lastPixel = currPixel;
                        continue;
                    }
                    for (lineX = x + 1; lineX < width && Math.abs((nArray = r.getPixel(lineX, y, (int[])null))[0] - (abovePixel = r.getPixel(lineX, y - 1, (int[])null))[0]) > 25 && Math.abs(currPixel[0] - nArray[0]) <= 25; ++lineX) {
                    }
                    int n = lineX - 1;
                    int lineWidth = n - x;
                    if (lineWidth > 50) {
                        horizontalRulings.add(new Ruling(new Point2D.Float(x, y), new Point2D.Float(n, y)));
                    }
                }
                lastPixel = currPixel;
            }
        }
        return horizontalRulings;
    }

    private List<Ruling> getVerticalRulings(BufferedImage image) {
        ArrayList<Ruling> verticalRulings = new ArrayList<Ruling>();
        WritableRaster r = image.getRaster();
        int width = r.getWidth();
        int height = r.getHeight();
        for (int y = 0; y < height; ++y) {
            int[] lastPixel = r.getPixel(0, y, (int[])null);
            for (int x = 1; x < width - 1; ++x) {
                int[] currPixel = r.getPixel(x, y, (int[])null);
                int diff = Math.abs(currPixel[0] - lastPixel[0]);
                if (diff > 25) {
                    int[] leftPixel;
                    int[] nArray;
                    int lineY;
                    boolean alreadyChecked = false;
                    for (Line2D.Float float_ : verticalRulings) {
                        if ((double)x != float_.getX1() || !((double)y >= float_.getY1()) || !((double)y <= float_.getY2())) continue;
                        alreadyChecked = true;
                        break;
                    }
                    if (alreadyChecked) {
                        lastPixel = currPixel;
                        continue;
                    }
                    for (lineY = y + 1; lineY < height && Math.abs((nArray = r.getPixel(x, lineY, (int[])null))[0] - (leftPixel = r.getPixel(x - 1, lineY, (int[])null))[0]) > 25 && Math.abs(currPixel[0] - nArray[0]) <= 25; ++lineY) {
                    }
                    int n = lineY - 1;
                    int lineLength = n - y;
                    if (lineLength > 10) {
                        verticalRulings.add(new Ruling(new Point2D.Float(x, y), new Point2D.Float(x, n)));
                    }
                }
                lastPixel = currPixel;
            }
        }
        return verticalRulings;
    }

    private PDDocument removeText(PDPage page) throws IOException {
        PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
        parser.parse();
        List tokens = parser.getTokens();
        ArrayList newTokens = new ArrayList();
        for (Object token : tokens) {
            Operator op;
            if (token instanceof Operator && ((op = (Operator)token).getName().equals("TJ") || op.getName().equals("Tj"))) {
                newTokens.remove(newTokens.size() - 1);
                continue;
            }
            newTokens.add(token);
        }
        PDDocument document = new PDDocument();
        PDPage newPage = document.importPage(page);
        newPage.setResources(page.getResources());
        PDStream newContents = new PDStream(document);
        OutputStream out = newContents.createOutputStream(COSName.FLATE_DECODE);
        ContentStreamWriter writer = new ContentStreamWriter(out);
        writer.writeTokens(newTokens);
        out.close();
        newPage.setContents(newContents);
        return document;
    }

    private static final class TextEdges
    extends ArrayList<List<TextEdge>> {
        public TextEdges(List<TextEdge> leftEdges, List<TextEdge> midEdges, List<TextEdge> rightEdges) {
            super(3);
            this.add(leftEdges);
            this.add(midEdges);
            this.add(rightEdges);
        }
    }

    private static final class TextEdge
    extends Line2D.Float {
        public static final int LEFT = 0;
        public static final int MID = 1;
        public static final int RIGHT = 2;
        public static final int NUM_TYPES = 3;
        public int intersectingTextRowCount = 0;

        public TextEdge(float x1, float y1, float x2, float y2) {
            super(x1, y1, x2, y2);
        }
    }

    private static final class RelevantEdges {
        public int edgeType;
        public int edgeCount;

        public RelevantEdges(int edgeType, int edgeCount) {
            this.edgeType = edgeType;
            this.edgeCount = edgeCount;
        }
    }
}

