/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.hdfs.waiter;

import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.WaiterConfiguration;

public class ResettingExponentialBackoffStrategy
implements DelayStrategy {
    private final long resetThresholdInSeconds;
    private int maxAttemptsPossible;

    public ResettingExponentialBackoffStrategy(long resetThresholdInSeconds) {
        this.resetThresholdInSeconds = resetThresholdInSeconds;
        this.maxAttemptsPossible = (int)(Math.log(resetThresholdInSeconds) / Math.log(2.0)) + 1;
    }

    public long nextDelay(WaiterConfiguration.WaitContext context) {
        long delay = (long)Math.pow(2.0, context.getAttemptsMade() % this.maxAttemptsPossible);
        if ((delay *= 1000L) <= 0L) {
            return this.resetThresholdInSeconds * 1000L;
        }
        return Math.min(delay, this.resetThresholdInSeconds * 1000L);
    }
}

