/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePlugin;
import org.apache.drill.exec.store.openTSDB.OpenTSDBStoragePluginConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="openTSDB-sub-scan")
public class OpenTSDBSubScan
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "OPEN_TSDB_SUB_SCAN";
    public final OpenTSDBStoragePluginConfig storage;
    private final List<SchemaPath> columns;
    private final OpenTSDBStoragePlugin openTSDBStoragePlugin;
    private final List<OpenTSDBSubScanSpec> tabletScanSpecList;

    @JsonCreator
    public OpenTSDBSubScan(@JacksonInject StoragePluginRegistry registry, @JsonProperty(value="storage") OpenTSDBStoragePluginConfig storage, @JsonProperty(value="tabletScanSpecList") LinkedList<OpenTSDBSubScanSpec> tabletScanSpecList, @JsonProperty(value="columns") List<SchemaPath> columns) throws ExecutionSetupException {
        super((String)null);
        this.openTSDBStoragePlugin = (OpenTSDBStoragePlugin)registry.resolve((StoragePluginConfig)storage, OpenTSDBStoragePlugin.class);
        this.tabletScanSpecList = tabletScanSpecList;
        this.storage = storage;
        this.columns = columns;
    }

    public OpenTSDBSubScan(OpenTSDBStoragePlugin plugin, OpenTSDBStoragePluginConfig config, List<OpenTSDBSubScanSpec> tabletInfoList, List<SchemaPath> columns) {
        super((String)null);
        this.openTSDBStoragePlugin = plugin;
        this.storage = config;
        this.tabletScanSpecList = tabletInfoList;
        this.columns = columns;
    }

    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public boolean isExecutable() {
        return false;
    }

    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) throws ExecutionSetupException {
        Preconditions.checkArgument((boolean)children.isEmpty());
        return new OpenTSDBSubScan(this.openTSDBStoragePlugin, this.storage, this.tabletScanSpecList, this.columns);
    }

    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return (T)physicalVisitor.visitSubScan((SubScan)this, value);
    }

    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    public List<OpenTSDBSubScanSpec> getTabletScanSpecList() {
        return this.tabletScanSpecList;
    }

    @JsonIgnore
    public OpenTSDBStoragePlugin getStorageEngine() {
        return this.openTSDBStoragePlugin;
    }

    @JsonProperty(value="storage")
    public OpenTSDBStoragePluginConfig getStorageConfig() {
        return this.storage;
    }

    public static class OpenTSDBSubScanSpec {
        private final String tableName;

        @JsonCreator
        public OpenTSDBSubScanSpec(@JsonProperty(value="tableName") String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

