/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.transform;

import java.util.List;
import java.util.UUID;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.iceberg.IcebergMetastoreContext;
import org.apache.drill.metastore.iceberg.operate.Delete;
import org.apache.drill.metastore.iceberg.operate.Overwrite;
import org.apache.drill.metastore.iceberg.transform.FilterTransformer;
import org.apache.drill.metastore.iceberg.transform.WriteData;
import org.apache.drill.metastore.iceberg.write.File;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;

public abstract class OperationTransformer<T> {
    protected final IcebergMetastoreContext<T> context;

    protected OperationTransformer(IcebergMetastoreContext<T> context) {
        this.context = context;
    }

    public Overwrite toOverwrite(String location, Expression expression, List<T> units) {
        WriteData writeData = this.context.transformer().inputData().units(units).execute();
        File file = this.context.fileWriter().records(writeData.records()).location(location).name(UUID.randomUUID().toString()).write();
        DataFile dataFile = DataFiles.builder((PartitionSpec)this.context.table().spec()).withInputFile(file.input()).withMetrics(file.metrics()).withPartition((StructLike)writeData.partition()).build();
        return new Overwrite(dataFile, expression);
    }

    public Delete toDelete(FilterExpression filter) {
        return new Delete(this.context.transformer().filter().transform(filter));
    }

    public Delete toDelete(org.apache.drill.metastore.operate.Delete delete) {
        FilterTransformer filterTransformer = this.context.transformer().filter();
        return new Delete(filterTransformer.transform(delete.filter()));
    }

    public abstract List<Overwrite> toOverwrite(List<T> var1);
}

