/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class KllDoublesSketchToStringPostAggregator
implements PostAggregator {
    private final String name;
    private final PostAggregator field;

    @JsonCreator
    public KllDoublesSketchToStringPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="field") PostAggregator field) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.field = (PostAggregator)Preconditions.checkNotNull((Object)field, (Object)"field is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.STRING;
    }

    @JsonProperty
    public PostAggregator getField() {
        return this.field;
    }

    public Object compute(Map<String, Object> combinedAggregators) {
        KllDoublesSketch sketch = (KllDoublesSketch)this.field.compute(combinedAggregators);
        return sketch.toString();
    }

    public Comparator<String> getComparator() {
        throw new IAE("Comparing sketch summaries is not supported", new Object[0]);
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(38).appendCacheable((Cacheable)this.field);
        return builder.build();
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> map) {
        return this;
    }

    public Set<String> getDependentFields() {
        return this.field.getDependentFields();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', field=" + this.field + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KllDoublesSketchToStringPostAggregator that = (KllDoublesSketchToStringPostAggregator)o;
        return this.name.equals(that.name) && this.field.equals(that.field);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.field);
    }
}

