/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;

public class DoublesSketchBuildBufferAggregatorHelper {
    private static final MemoryRequestServer MEM_REQ_SERVER = new DefaultMemoryRequestServer();
    private final int size;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<UpdateDoublesSketch>> sketches = new IdentityHashMap();

    public DoublesSketchBuildBufferAggregatorHelper(int size, int maxIntermediateSize) {
        this.size = size;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buffer, int position) {
        WritableMemory mem = this.getMemory(buffer);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        UpdateDoublesSketch sketch = DoublesSketch.builder().setK(this.size).build(region);
        this.putSketch(buffer, position, sketch);
    }

    public CompactDoublesSketch get(ByteBuffer buffer, int position) {
        return ((UpdateDoublesSketch)this.sketches.get(buffer).get(position)).compact();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        WritableMemory oldRegion;
        UpdateDoublesSketch sketch = (UpdateDoublesSketch)this.sketches.get(oldBuffer).get(oldPosition);
        if (sketch.isSameResource((Memory)(oldRegion = this.getMemory(oldBuffer).writableRegion((long)oldPosition, (long)this.maxIntermediateSize)))) {
            WritableMemory newRegion = this.getMemory(newBuffer).writableRegion((long)newPosition, (long)this.maxIntermediateSize);
            sketch = UpdateDoublesSketch.wrap((WritableMemory)newRegion);
        }
        this.putSketch(newBuffer, newPosition, sketch);
        Int2ObjectMap<UpdateDoublesSketch> map = this.sketches.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.sketches.remove(oldBuffer);
            this.memCache.remove(oldBuffer);
        }
    }

    public void clear() {
        this.sketches.clear();
        this.memCache.clear();
    }

    public UpdateDoublesSketch getSketchAtPosition(ByteBuffer buf, int position) {
        return (UpdateDoublesSketch)this.sketches.get(buf).get(position);
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        return this.memCache.computeIfAbsent(buffer, buf -> WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)MEM_REQ_SERVER));
    }

    private void putSketch(ByteBuffer buffer, int position, UpdateDoublesSketch sketch) {
        Int2ObjectMap map = this.sketches.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, (Object)sketch);
    }
}

