/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import org.apache.druid.msq.counters.CounterSnapshots;

public class CounterSnapshotsTree {
    @GuardedBy(value="snapshotsMap")
    private final Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> snapshotsMap = new Int2ObjectAVLTreeMap();

    @JsonCreator
    public static CounterSnapshotsTree fromMap(Map<Integer, Map<Integer, CounterSnapshots>> map) {
        CounterSnapshotsTree retVal = new CounterSnapshotsTree();
        retVal.putAll(map);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int stageNumber, int workerNumber, CounterSnapshots snapshots) {
        Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> int2ObjectMap = this.snapshotsMap;
        synchronized (int2ObjectMap) {
            ((Int2ObjectMap)this.snapshotsMap.computeIfAbsent(stageNumber, ignored -> new Int2ObjectAVLTreeMap())).put(workerNumber, (Object)snapshots);
        }
    }

    public void putAll(CounterSnapshotsTree other) {
        this.putAll(other.copyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> int2ObjectMap = this.snapshotsMap;
        synchronized (int2ObjectMap) {
            return this.snapshotsMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonValue
    public Map<Integer, Map<Integer, CounterSnapshots>> copyMap() {
        Int2ObjectAVLTreeMap retVal = new Int2ObjectAVLTreeMap();
        Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> int2ObjectMap = this.snapshotsMap;
        synchronized (int2ObjectMap) {
            for (Int2ObjectMap.Entry entry : this.snapshotsMap.int2ObjectEntrySet()) {
                retVal.put(entry.getIntKey(), new Int2ObjectAVLTreeMap((Int2ObjectMap)entry.getValue()));
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, CounterSnapshots> snapshotForStage(int stageNumber) {
        Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> int2ObjectMap = this.snapshotsMap;
        synchronized (int2ObjectMap) {
            return (Map)this.snapshotsMap.getOrDefault(stageNumber, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAll(Map<Integer, Map<Integer, CounterSnapshots>> otherMap) {
        Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> int2ObjectMap = this.snapshotsMap;
        synchronized (int2ObjectMap) {
            for (Map.Entry<Integer, Map<Integer, CounterSnapshots>> stageEntry : otherMap.entrySet()) {
                for (Map.Entry<Integer, CounterSnapshots> workerEntry : stageEntry.getValue().entrySet()) {
                    this.put(stageEntry.getKey(), workerEntry.getKey(), workerEntry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Int2ObjectMap<Int2ObjectMap<CounterSnapshots>> int2ObjectMap = this.snapshotsMap;
        synchronized (int2ObjectMap) {
            return "CounterSnapshotsTree{snapshotsMap=" + String.valueOf(this.snapshotsMap) + "}";
        }
    }
}

