/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.ConfigurationType;
import net.spy.memcached.ops.DeleteConfigOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.ascii.OperationImpl;

final class DeleteConfigOperationImpl
extends OperationImpl
implements DeleteConfigOperation {
    private static final String CMD = "config delete";
    private static final int OVERHEAD = 32;
    private static final OperationStatus DELETED = new OperationStatus(true, "DELETED");
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND");
    private final ConfigurationType type;

    public DeleteConfigOperationImpl(ConfigurationType type, OperationCallback cb) {
        super(cb);
        this.type = type;
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Delete of %s returned %s", new Object[]{this.type, line});
        this.getCallback().receivedStatus(this.matchStatus(line, DELETED, NOT_FOUND));
        this.transitionState(OperationState.COMPLETE);
    }

    @Override
    public void initialize() {
        ByteBuffer b = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.type.getValue()).length + 32);
        this.setArguments(b, CMD, this.type.getValue());
        b.flip();
        this.setBuffer(b);
    }

    @Override
    public ConfigurationType getType() {
        return this.type;
    }

    public String toString() {
        return "Cmd: delete config type: " + (Object)((Object)this.type);
    }
}

