/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.sql.calcite.parser.DruidSqlParser;
import org.apache.druid.sql.calcite.parser.StatementAndSetContext;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;

public class SqlQueryPlus {
    private final String sql;
    @Nullable
    private final SqlNode sqlNode;
    private boolean allowSetStatements;
    private final Map<String, Object> stmtContext;
    private final Set<String> authContextKeys;
    private final List<TypedValue> parameters;
    private final AuthenticationResult authResult;

    private SqlQueryPlus(String sql, SqlNode sqlNode, boolean allowSetStatements, Map<String, Object> stmtContext, Set<String> authContextKeys, List<TypedValue> parameters, AuthenticationResult authResult) {
        this.sql = (String)Preconditions.checkNotNull((Object)sql);
        this.sqlNode = sqlNode;
        this.allowSetStatements = allowSetStatements;
        this.stmtContext = stmtContext == null ? Collections.emptyMap() : Collections.unmodifiableMap(stmtContext);
        this.authContextKeys = authContextKeys == null ? Collections.emptySet() : Collections.unmodifiableSet(authContextKeys);
        this.parameters = parameters == null ? Collections.emptyList() : parameters;
        this.authResult = (AuthenticationResult)Preconditions.checkNotNull((Object)authResult);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sql) {
        return new Builder().sql(sql);
    }

    public String sql() {
        return this.sql;
    }

    public SqlNode sqlNode() {
        if (this.sqlNode == null) {
            throw DruidException.defensive((String)"sqlNode not set", (Object[])new Object[0]);
        }
        return this.sqlNode;
    }

    public Map<String, Object> context() {
        return this.stmtContext;
    }

    public Set<String> authContextKeys() {
        return this.authContextKeys;
    }

    public List<TypedValue> parameters() {
        return this.parameters;
    }

    public AuthenticationResult authResult() {
        return this.authResult;
    }

    public SqlQueryPlus withContext(Map<String, Object> defaultContext, Map<String, Object> userProvidedContext) {
        return new SqlQueryPlus(this.sql, this.sqlNode, this.allowSetStatements, QueryContexts.override(defaultContext, userProvidedContext), userProvidedContext == null ? Set.of() : userProvidedContext.keySet(), this.parameters, this.authResult);
    }

    public SqlQueryPlus withParameters(List<TypedValue> parameters) {
        return new SqlQueryPlus(this.sql, this.sqlNode, this.allowSetStatements, this.stmtContext, this.authContextKeys, parameters, this.authResult);
    }

    public SqlQueryPlus freshCopy() {
        return new SqlQueryPlus(this.sql, DruidSqlParser.parse(this.sql, this.allowSetStatements).getMainStatement(), this.allowSetStatements, this.stmtContext, this.authContextKeys, this.parameters, this.authResult);
    }

    public String toString() {
        return "SqlQueryPlus{sql='" + this.sql + "', sqlNode=" + String.valueOf(this.sqlNode) + ", allowSetStatements=" + this.allowSetStatements + ", stmtContext=" + String.valueOf(this.stmtContext) + ", authContextKeys=" + String.valueOf(this.authContextKeys) + ", parameters=" + String.valueOf(this.parameters) + ", authResult=" + String.valueOf(this.authResult) + "}";
    }

    public static class Builder {
        private String sql;
        private Map<String, Object> systemDefaultContext;
        private Map<String, Object> queryContext;
        private List<TypedValue> parameters;
        private AuthenticationResult authResult;

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder systemDefaultContext(Map<String, Object> systemDefaultContext) {
            this.systemDefaultContext = systemDefaultContext;
            return this;
        }

        public Builder queryContext(Map<String, Object> queryContext) {
            this.queryContext = queryContext;
            return this;
        }

        public Builder parameters(List<TypedValue> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder sqlParameters(List<SqlParameter> parameters) {
            this.parameters = parameters == null ? null : SqlQuery.getParameterList(parameters);
            return this;
        }

        public Builder auth(AuthenticationResult authResult) {
            this.authResult = authResult;
            return this;
        }

        public SqlQueryPlus build() {
            StatementAndSetContext statementAndSetContext = DruidSqlParser.parse(this.sql, true);
            Map userProvidedContext = statementAndSetContext.getSetContext().isEmpty() ? this.queryContext : QueryContexts.override(this.queryContext, statementAndSetContext.getSetContext());
            Map stmtContext = this.systemDefaultContext == null ? userProvidedContext : QueryContexts.override(this.systemDefaultContext, (Map)userProvidedContext);
            return new SqlQueryPlus(this.sql, statementAndSetContext.getMainStatement(), true, stmtContext, userProvidedContext == null ? Set.of() : userProvidedContext.keySet(), this.parameters, this.authResult);
        }

        public SqlQueryPlus buildJdbc() {
            return new SqlQueryPlus(this.sql, null, false, QueryContexts.override(this.systemDefaultContext, this.queryContext), this.queryContext == null ? Set.of() : this.queryContext.keySet(), this.parameters, this.authResult);
        }
    }
}

