/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public interface InputEntity {
    public static final Logger LOG = new Logger(InputEntity.class);
    public static final int DEFAULT_FETCH_BUFFER_SIZE = 4096;
    public static final int DEFAULT_MAX_NUM_FETCH_TRIES = 3;

    @Nullable
    public URI getUri();

    public InputStream open() throws IOException;

    default public CleanableFile fetch(File temporaryDirectory, byte[] fetchBuffer) throws IOException {
        final File tempFile = File.createTempFile("druid-input-entity", ".tmp", temporaryDirectory);
        LOG.debug("Fetching entity into file[%s]", tempFile.getAbsolutePath());
        URI uri = this.getUri();
        String message = uri == null ? StringUtils.format("Failed to fetch entity into local file [%s]", tempFile.getAbsolutePath()) : StringUtils.format("Failed to fetch entity [%s] into local file [%s]", uri, tempFile.getAbsolutePath());
        FileUtils.copyLarge(this::open, tempFile, fetchBuffer, this.getRetryCondition(), 3, message);
        return new CleanableFile(){

            @Override
            public File file() {
                return tempFile;
            }

            @Override
            public void close() {
                if (!tempFile.delete()) {
                    LOG.warn("Failed to remove file[%s]", tempFile.getAbsolutePath());
                }
            }
        };
    }

    default public Predicate<Throwable> getRetryCondition() {
        return Predicates.alwaysFalse();
    }

    public static interface CleanableFile
    extends Closeable {
        public File file();
    }
}

