/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.PasswordProvider;

public class HttpEntity
extends RetryingInputEntity {
    private static final Logger LOG = new Logger(HttpEntity.class);
    private final URI uri;
    @Nullable
    private final String httpAuthenticationUsername;
    @Nullable
    private final PasswordProvider httpAuthenticationPasswordProvider;
    private final Map<String, String> requestHeaders;

    HttpEntity(URI uri, @Nullable String httpAuthenticationUsername, @Nullable PasswordProvider httpAuthenticationPasswordProvider, @Nullable Map<String, String> requestHeaders) {
        this.uri = uri;
        this.httpAuthenticationUsername = httpAuthenticationUsername;
        this.httpAuthenticationPasswordProvider = httpAuthenticationPasswordProvider;
        this.requestHeaders = requestHeaders;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    protected InputStream readFrom(long offset) throws IOException {
        return HttpEntity.openInputStream(this.uri, this.httpAuthenticationUsername, this.httpAuthenticationPasswordProvider, offset, this.requestHeaders);
    }

    @Override
    protected String getPath() {
        return this.uri.getPath();
    }

    @Override
    public Predicate<Throwable> getRetryCondition() {
        return t -> t instanceof IOException;
    }

    public static InputStream openInputStream(URI object, String userName, PasswordProvider passwordProvider, long offset, Map<String, String> requestHeaders) throws IOException {
        boolean withContentRange;
        URLConnection urlConnection = object.toURL().openConnection();
        if (requestHeaders != null && requestHeaders.size() > 0) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                urlConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (!Strings.isNullOrEmpty((String)userName) && passwordProvider != null) {
            String userPass = userName + ":" + passwordProvider.getPassword();
            String basicAuthString = "Basic " + Base64.getEncoder().encodeToString(StringUtils.toUtf8(userPass));
            urlConnection.setRequestProperty("Authorization", basicAuthString);
        }
        urlConnection.addRequestProperty("Range", StringUtils.format("bytes=%d-", offset));
        String contentRange = urlConnection.getHeaderField("Content-Range");
        boolean bl = withContentRange = contentRange != null && contentRange.startsWith("bytes ");
        if (withContentRange && offset > 0L) {
            return urlConnection.getInputStream();
        }
        if (!withContentRange && offset > 0L) {
            LOG.warn("Since the input source doesn't support range requests, the object input stream is opened from the start and then skipped. This may make the ingestion speed slower. Consider enabling prefetch if you see this message a lot.", new Object[0]);
        }
        InputStream in = urlConnection.getInputStream();
        try {
            long skipped = in.skip(offset);
            if (skipped != offset) {
                in.close();
                throw new ISE("Requested to skip [%s] bytes, but actual number of bytes skipped is [%s]", offset, skipped);
            }
            return in;
        }
        catch (IOException ex) {
            in.close();
            throw ex;
        }
    }
}

