/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.allocation;

import org.apache.druid.frame.allocation.ArenaMemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;

public class ArenaMemoryAllocatorFactory
implements MemoryAllocatorFactory {
    private static final int FRAME_SIZE = 8000000;
    private final int capacity;

    public ArenaMemoryAllocatorFactory(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public MemoryAllocator newAllocator() {
        return ArenaMemoryAllocator.createOnHeap(this.capacity);
    }

    @Override
    public long allocatorCapacity() {
        return this.capacity;
    }

    public static MemoryAllocatorFactory makeDefault() {
        return new ArenaMemoryAllocatorFactory(8000000);
    }
}

