/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.lang.reflect.Array;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class BivariateObjectsFunctionVectorProcessor<TLeftInput, TRightInput, TOutput>
implements ExprVectorProcessor<TOutput> {
    final ExprVectorProcessor<TLeftInput> left;
    final ExprVectorProcessor<TRightInput> right;
    final TOutput outValues;

    protected BivariateObjectsFunctionVectorProcessor(ExprVectorProcessor<TLeftInput> left, ExprVectorProcessor<TRightInput> right, TOutput outValues) {
        this.left = left;
        this.right = right;
        this.outValues = outValues;
    }

    @Override
    public ExprEvalVector<TOutput> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TLeftInput> lhs = this.left.evalVector(bindings);
        ExprEvalVector<TRightInput> rhs = this.right.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        TLeftInput leftInput = lhs.values();
        TRightInput rightInput = rhs.values();
        for (int i = 0; i < currentSize; ++i) {
            if (Array.get(leftInput, i) == null || Array.get(rightInput, i) == null) {
                this.processNull(i);
                continue;
            }
            this.processIndex(leftInput, rightInput, i);
        }
        return this.asEval();
    }

    @Override
    public int maxVectorSize() {
        return this.left.maxVectorSize();
    }

    abstract void processIndex(TLeftInput var1, TRightInput var2, int var3);

    abstract void processNull(int var1);

    abstract ExprEvalVector<TOutput> asEval();
}

