/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class NilVectorSelector
implements VectorValueSelector,
VectorObjectSelector,
SingleValueDimensionVectorSelector,
IdLookup {
    private static final boolean[] DEFAULT_NULLS_VECTOR = new boolean[512];
    private static final int[] DEFAULT_INT_VECTOR = new int[512];
    private static final long[] DEFAULT_LONG_VECTOR = new long[512];
    private static final float[] DEFAULT_FLOAT_VECTOR = new float[512];
    private static final double[] DEFAULT_DOUBLE_VECTOR = new double[512];
    private static final Object[] DEFAULT_OBJECT_VECTOR = new Object[512];
    private final VectorSizeInspector vectorSizeInspector;
    private final boolean[] nulls;
    private final int[] ints;
    private final long[] longs;
    private final float[] floats;
    private final double[] doubles;
    private final Object[] objects;

    private NilVectorSelector(VectorSizeInspector vectorSizeInspector, boolean[] nulls, int[] ints, long[] longs, float[] floats, double[] doubles, Object[] objects) {
        this.vectorSizeInspector = vectorSizeInspector;
        this.nulls = nulls;
        this.ints = ints;
        this.longs = longs;
        this.floats = floats;
        this.doubles = doubles;
        this.objects = objects;
    }

    public static NilVectorSelector create(VectorSizeInspector vectorSizeInspector) {
        if (vectorSizeInspector.getMaxVectorSize() <= 512) {
            return new NilVectorSelector(vectorSizeInspector, DEFAULT_NULLS_VECTOR, DEFAULT_INT_VECTOR, DEFAULT_LONG_VECTOR, DEFAULT_FLOAT_VECTOR, DEFAULT_DOUBLE_VECTOR, DEFAULT_OBJECT_VECTOR);
        }
        boolean[] nulls = new boolean[vectorSizeInspector.getMaxVectorSize()];
        Arrays.fill(nulls, true);
        return new NilVectorSelector(vectorSizeInspector, nulls, new int[vectorSizeInspector.getMaxVectorSize()], new long[vectorSizeInspector.getMaxVectorSize()], new float[vectorSizeInspector.getMaxVectorSize()], new double[vectorSizeInspector.getMaxVectorSize()], new Object[vectorSizeInspector.getMaxVectorSize()]);
    }

    @Override
    public long[] getLongVector() {
        return this.longs;
    }

    @Override
    public float[] getFloatVector() {
        return this.floats;
    }

    @Override
    public double[] getDoubleVector() {
        return this.doubles;
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        return this.nulls;
    }

    @Override
    public int[] getRowVector() {
        return this.ints;
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return null;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(@Nullable String name) {
        return name == null ? 0 : -1;
    }

    @Override
    public Object[] getObjectVector() {
        return this.objects;
    }

    @Override
    public int getCurrentVectorSize() {
        return this.vectorSizeInspector.getCurrentVectorSize();
    }

    @Override
    public int getMaxVectorSize() {
        return this.vectorSizeInspector.getMaxVectorSize();
    }

    static {
        Arrays.fill(DEFAULT_NULLS_VECTOR, true);
    }
}

