/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.PathFilter;
import com.amazonaws.services.ec2.model.transform.FilterPortRangeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class PathFilterStaxUnmarshaller
implements Unmarshaller<PathFilter, StaxUnmarshallerContext> {
    private static PathFilterStaxUnmarshaller instance;

    public PathFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        PathFilter pathFilter = new PathFilter();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return pathFilter;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("sourceAddress", targetDepth)) {
                    pathFilter.setSourceAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sourcePortRange", targetDepth)) {
                    pathFilter.setSourcePortRange(FilterPortRangeStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("destinationAddress", targetDepth)) {
                    pathFilter.setDestinationAddress(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("destinationPortRange", targetDepth)) continue;
                pathFilter.setDestinationPortRange(FilterPortRangeStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return pathFilter;
    }

    public static PathFilterStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PathFilterStaxUnmarshaller();
        }
        return instance;
    }
}

