/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.SentinelCheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.DataFetcherResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.MetricsCollectingKinesisProxyDecorator;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.model.ChildShard;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.amazonaws.util.CollectionUtils;
import com.google.common.collect.Iterables;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisDataFetcher {
    private static final Log LOG = LogFactory.getLog(KinesisDataFetcher.class);
    private String nextIterator;
    private IKinesisProxy kinesisProxy;
    private final String shardId;
    private boolean isShardEndReached;
    private boolean isInitialized;
    private String lastKnownSequenceNumber;
    private InitialPositionInStreamExtended initialPositionInStream;
    private List<ChildShard> childShards = Collections.emptyList();
    final DataFetcherResult TERMINAL_RESULT = new DataFetcherResult(){

        @Override
        public GetRecordsResult getResult() {
            return new GetRecordsResult().withMillisBehindLatest(null).withRecords(Collections.emptyList()).withNextShardIterator(null).withChildShards(Collections.emptyList());
        }

        @Override
        public GetRecordsResult accept() {
            KinesisDataFetcher.this.isShardEndReached = true;
            return this.getResult();
        }

        @Override
        public boolean isShardEnd() {
            return KinesisDataFetcher.this.isShardEndReached;
        }
    };

    public KinesisDataFetcher(IKinesisProxy kinesisProxy, ShardInfo shardInfo) {
        this.shardId = shardInfo.getShardId();
        this.kinesisProxy = new MetricsCollectingKinesisProxyDecorator("KinesisDataFetcher", kinesisProxy, this.shardId);
    }

    public DataFetcherResult getRecords(int maxRecords) {
        if (!this.isInitialized) {
            throw new IllegalArgumentException("KinesisDataFetcher.getRecords called before initialization.");
        }
        if (this.nextIterator != null) {
            try {
                return new AdvancingResult(this.kinesisProxy.get(this.nextIterator, maxRecords));
            }
            catch (ResourceNotFoundException e) {
                LOG.info((Object)("Caught ResourceNotFoundException when fetching records for shard " + this.shardId));
                return this.TERMINAL_RESULT;
            }
        }
        LOG.info((Object)("Skipping fetching records from Kinesis for shard " + this.shardId + ": nextIterator is null."));
        return this.TERMINAL_RESULT;
    }

    private boolean isValidResult(GetRecordsResult getRecordsResult) {
        if (getRecordsResult.getNextShardIterator() == null && CollectionUtils.isNullOrEmpty((Collection)getRecordsResult.getChildShards()) || getRecordsResult.getNextShardIterator() != null && !CollectionUtils.isNullOrEmpty((Collection)getRecordsResult.getChildShards())) {
            return false;
        }
        for (ChildShard childShard : getRecordsResult.getChildShards()) {
            if (!CollectionUtils.isNullOrEmpty((Collection)childShard.getParentShards())) continue;
            return false;
        }
        return true;
    }

    public void initialize(String initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        LOG.info((Object)("Initializing shard " + this.shardId + " with " + initialCheckpoint));
        this.advanceIteratorTo(initialCheckpoint, initialPositionInStream);
        this.isInitialized = true;
    }

    public void initialize(ExtendedSequenceNumber initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        LOG.info((Object)("Initializing shard " + this.shardId + " with " + initialCheckpoint.getSequenceNumber()));
        this.advanceIteratorTo(initialCheckpoint.getSequenceNumber(), initialPositionInStream);
        this.isInitialized = true;
    }

    void advanceIteratorTo(String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("SequenceNumber should not be null: shardId " + this.shardId);
        }
        this.nextIterator = sequenceNumber.equals(SentinelCheckpoint.LATEST.toString()) ? this.getIterator(ShardIteratorType.LATEST.toString()) : (sequenceNumber.equals(SentinelCheckpoint.TRIM_HORIZON.toString()) ? this.getIterator(ShardIteratorType.TRIM_HORIZON.toString()) : (sequenceNumber.equals(SentinelCheckpoint.AT_TIMESTAMP.toString()) ? this.getIterator(initialPositionInStream.getTimestamp()) : (sequenceNumber.equals(SentinelCheckpoint.SHARD_END.toString()) ? null : this.getIterator(ShardIteratorType.AT_SEQUENCE_NUMBER.toString(), sequenceNumber))));
        if (this.nextIterator == null) {
            LOG.info((Object)("Reached shard end: cannot advance iterator for shard " + this.shardId));
            this.isShardEndReached = true;
        }
        this.lastKnownSequenceNumber = sequenceNumber;
        this.initialPositionInStream = initialPositionInStream;
    }

    private String getIterator(String iteratorType, String sequenceNumber) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling getIterator for " + this.shardId + ", iterator type " + iteratorType + " and sequence number " + sequenceNumber));
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, iteratorType, sequenceNumber);
        }
        catch (ResourceNotFoundException e) {
            LOG.info((Object)("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId), (Throwable)e);
        }
        return iterator;
    }

    private String getIterator(String iteratorType) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling getIterator for " + this.shardId + " and iterator type " + iteratorType));
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, iteratorType);
        }
        catch (ResourceNotFoundException e) {
            LOG.info((Object)("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId), (Throwable)e);
        }
        return iterator;
    }

    private String getIterator(Date timestamp) {
        String iterator = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Calling getIterator for " + this.shardId + " and timestamp " + timestamp));
            }
            iterator = this.kinesisProxy.getIterator(this.shardId, timestamp);
        }
        catch (ResourceNotFoundException e) {
            LOG.info((Object)("Caught ResourceNotFoundException when getting an iterator for shard " + this.shardId), (Throwable)e);
        }
        return iterator;
    }

    public void restartIterator() {
        if (StringUtils.isEmpty((CharSequence)this.lastKnownSequenceNumber) || this.initialPositionInStream == null) {
            throw new IllegalStateException("Make sure to initialize the KinesisDataFetcher before restarting the iterator.");
        }
        this.advanceIteratorTo(this.lastKnownSequenceNumber, this.initialPositionInStream);
    }

    protected boolean isShardEndReached() {
        return this.isShardEndReached;
    }

    protected List<ChildShard> getChildShards() {
        return this.childShards;
    }

    String getNextIterator() {
        return this.nextIterator;
    }

    class AdvancingResult
    implements DataFetcherResult {
        final GetRecordsResult result;

        @Override
        public GetRecordsResult getResult() {
            return this.result;
        }

        @Override
        public GetRecordsResult accept() {
            if (!KinesisDataFetcher.this.isValidResult(this.result)) {
                throw new SdkClientException("Shard " + KinesisDataFetcher.this.shardId + ": GetRecordsResult is not valid. NextShardIterator: " + this.result.getNextShardIterator() + ". ChildShards: " + this.result.getChildShards());
            }
            KinesisDataFetcher.this.nextIterator = this.result.getNextShardIterator();
            if (!CollectionUtils.isNullOrEmpty((Collection)this.result.getRecords())) {
                KinesisDataFetcher.this.lastKnownSequenceNumber = ((Record)Iterables.getLast((Iterable)this.result.getRecords())).getSequenceNumber();
            }
            if (KinesisDataFetcher.this.nextIterator == null) {
                LOG.info((Object)("Reached shard end: nextIterator is null in AdvancingResult.accept for shard " + KinesisDataFetcher.this.shardId + ". childShards: " + this.result.getChildShards()));
                if (!CollectionUtils.isNullOrEmpty((Collection)this.result.getChildShards())) {
                    KinesisDataFetcher.this.childShards = this.result.getChildShards();
                }
                KinesisDataFetcher.this.isShardEndReached = true;
            }
            return this.getResult();
        }

        @Override
        public boolean isShardEnd() {
            return KinesisDataFetcher.this.isShardEndReached;
        }

        @ConstructorProperties(value={"result"})
        public AdvancingResult(GetRecordsResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdvancingResult)) {
                return false;
            }
            AdvancingResult other = (AdvancingResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GetRecordsResult this$result = this.getResult();
            GetRecordsResult other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdvancingResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GetRecordsResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "KinesisDataFetcher.AdvancingResult(result=" + this.getResult() + ")";
        }
    }
}

