/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.joda.time.DateTime;

public class ProtobufInputRowSchema
extends InputRowSchema {
    public ProtobufInputRowSchema(InputRowSchema inputRowSchema) {
        super((TimestampSpec)new ProtobufTimestampSpec(inputRowSchema.getTimestampSpec()), inputRowSchema.getDimensionsSpec(), inputRowSchema.getColumnsFilter(), inputRowSchema.getMetricNames());
    }

    static class ProtobufTimestampSpec
    extends TimestampSpec {
        public ProtobufTimestampSpec(TimestampSpec timestampSpec) {
            super(timestampSpec.getTimestampColumn(), timestampSpec.getTimestampFormat(), timestampSpec.getMissingValue());
        }

        @Nullable
        public DateTime extractTimestamp(@Nullable Map<String, Object> input) {
            Object rawTimestamp = this.getRawTimestamp(input);
            if (rawTimestamp instanceof Message) {
                try {
                    String timestampStr = JsonFormat.printer().print((Message)rawTimestamp);
                    return this.parseDateTime(timestampStr);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new ParseException(null, (Throwable)e, "Protobuf message could not be parsed", new Object[0]);
                }
            }
            return this.parseDateTime(rawTimestamp);
        }
    }
}

