/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cluster.task;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.coordinator.CoordinatorClientImpl;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.testing.cluster.ClusterTestingTaskConfig;
import org.joda.time.Duration;

public class FaultyCoordinatorClient
extends CoordinatorClientImpl {
    private static final Logger log = new Logger(FaultyCoordinatorClient.class);
    private final Provider<ClusterTestingTaskConfig> testConfigProvider;
    private final ConcurrentHashMap<SegmentDescriptor, Stopwatch> segmentHandoffTimers = new ConcurrentHashMap();

    @Inject
    public FaultyCoordinatorClient(Provider<ClusterTestingTaskConfig> testingConfigProvider, @Json ObjectMapper jsonMapper, @EscalatedGlobal ServiceClientFactory clientFactory, @Coordinator ServiceLocator serviceLocator) {
        super(clientFactory.makeClient(NodeRole.COORDINATOR.getJsonName(), serviceLocator, (ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(6L).build()), jsonMapper);
        this.testConfigProvider = testingConfigProvider;
    }

    public ListenableFuture<Boolean> isHandoffComplete(String dataSource, SegmentDescriptor descriptor) {
        Duration minHandoffDelay = this.getHandoffDelay();
        if (minHandoffDelay != null) {
            Stopwatch sinceHandoffCheckStarted = this.segmentHandoffTimers.computeIfAbsent(descriptor, d -> Stopwatch.createStarted());
            if (sinceHandoffCheckStarted.hasElapsed(minHandoffDelay)) {
                log.info("Min handoff delay[%s] has elapsed for segment[%s]. Checking with Coordinator for actual handoff status.", new Object[]{minHandoffDelay, descriptor});
            } else {
                return Futures.immediateFuture((Object)false);
            }
        }
        return super.isHandoffComplete(dataSource, descriptor);
    }

    private Duration getHandoffDelay() {
        return ((ClusterTestingTaskConfig)this.testConfigProvider.get()).getCoordinatorClientConfig().getMinSegmentHandoffDelay();
    }
}

