/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.cluster.task;

import java.io.IOException;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalAppendAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.SegmentTransactionalReplaceAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.cluster.ClusterTestingTaskConfig;
import org.joda.time.Duration;

public class FaultyRemoteTaskActionClient
implements TaskActionClient {
    private static final Logger log = new Logger(FaultyRemoteTaskActionClient.class);
    private final TaskActionClient delegate;
    private final ClusterTestingTaskConfig.TaskActionClientConfig config;

    FaultyRemoteTaskActionClient(ClusterTestingTaskConfig.TaskActionClientConfig config, TaskActionClient delegate) {
        this.config = config;
        this.delegate = delegate;
        log.info("Initializing FaultyRemoteTaskActionClient with config[%s].", new Object[]{config});
    }

    public <RetType> RetType submit(TaskAction<RetType> taskAction) throws IOException {
        if (taskAction instanceof SegmentAllocateAction && this.config.getSegmentAllocateDelay() != null) {
            log.warn("Sleeping for duration[%s] before allocating segments.", new Object[]{this.config.getSegmentAllocateDelay()});
            FaultyRemoteTaskActionClient.sleep(this.config.getSegmentAllocateDelay());
        }
        if (FaultyRemoteTaskActionClient.isPublishAction(taskAction) && this.config.getSegmentPublishDelay() != null) {
            log.warn("Sleeping for duration[%s] before publishing segments.", new Object[]{this.config.getSegmentPublishDelay()});
            FaultyRemoteTaskActionClient.sleep(this.config.getSegmentPublishDelay());
        }
        return (RetType)this.delegate.submit(taskAction);
    }

    private static <R> boolean isPublishAction(TaskAction<R> taskAction) {
        return taskAction instanceof SegmentTransactionalInsertAction || taskAction instanceof SegmentTransactionalAppendAction || taskAction instanceof SegmentTransactionalReplaceAction;
    }

    private static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.getMillis());
        }
        catch (InterruptedException e) {
            log.info("Interrupted while sleeping before task action.", new Object[0]);
        }
    }
}

