/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.maxwell;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.maxwell.MaxwellJsonDecodingFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

public class MaxwellJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 2L;
    private static final String FIELD_OLD = "old";
    private static final String OP_INSERT = "insert";
    private static final String OP_UPDATE = "update";
    private static final String OP_DELETE = "delete";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final boolean hasMetadata;
    private final MetadataConverter[] metadataConverters;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean ignoreParseErrors;
    private final List<String> fieldNames;
    private final int fieldCount;
    private transient List<GenericRowData> genericRowDataList;

    public MaxwellJsonDeserializationSchema(DataType physicalDataType, List<MaxwellJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        RowType jsonRowType = MaxwellJsonDeserializationSchema.createJsonRowType(physicalDataType, requestedMetadata);
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(jsonRowType, producedTypeInfo, false, ignoreParseErrors, timestampFormat);
        this.hasMetadata = requestedMetadata.size() > 0;
        this.metadataConverters = MaxwellJsonDeserializationSchema.createMetadataConverters(jsonRowType, requestedMetadata);
        this.producedTypeInfo = producedTypeInfo;
        this.ignoreParseErrors = ignoreParseErrors;
        RowType physicalRowType = (RowType)physicalDataType.getLogicalType();
        this.fieldNames = physicalRowType.getFieldNames();
        this.fieldCount = physicalRowType.getFieldCount();
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.genericRowDataList = new ArrayList<GenericRowData>();
        this.jsonDeserializer.open(context);
    }

    public RowData deserialize(byte[] message) throws IOException {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block12: {
            if (message == null || message.length == 0) {
                return;
            }
            this.genericRowDataList.clear();
            try {
                JsonNode root = this.jsonDeserializer.deserializeToJsonNode(message);
                GenericRowData row = (GenericRowData)this.jsonDeserializer.convertToRowData(root);
                String type = row.getString(2).toString();
                if (OP_INSERT.equals(type)) {
                    GenericRowData insert = (GenericRowData)row.getRow(0, this.fieldCount);
                    insert.setRowKind(RowKind.INSERT);
                    this.genericRowDataList.add(this.handleRow(row, insert));
                } else if (OP_UPDATE.equals(type)) {
                    GenericRowData after = (GenericRowData)row.getRow(0, this.fieldCount);
                    GenericRowData before = (GenericRowData)row.getRow(1, this.fieldCount);
                    JsonNode oldField = root.get(FIELD_OLD);
                    for (int f = 0; f < this.fieldCount; ++f) {
                        if (!before.isNullAt(f) || oldField.findValue(this.fieldNames.get(f)) != null) continue;
                        before.setField(f, after.getField(f));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    this.genericRowDataList.add(this.handleRow(row, before));
                    this.genericRowDataList.add(this.handleRow(row, after));
                } else if (OP_DELETE.equals(type)) {
                    GenericRowData delete = (GenericRowData)row.getRow(0, this.fieldCount);
                    delete.setRowKind(RowKind.DELETE);
                    this.genericRowDataList.add(this.handleRow(row, delete));
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"type\" value \"%s\". The Maxwell JSON message is '%s'", type, new String(message)));
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block12;
                throw new IOException(String.format("Corrupt Maxwell JSON message '%s'.", new String(message)), t);
            }
        }
        for (GenericRowData genericRowData : this.genericRowDataList) {
            out.collect((Object)genericRowData);
        }
    }

    private GenericRowData handleRow(GenericRowData rootRow, GenericRowData physicalRow) {
        if (!this.hasMetadata) {
            return physicalRow;
        }
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), this.fieldCount + metadataArity);
        for (int physicalPos = 0; physicalPos < this.fieldCount; ++physicalPos) {
            producedRow.setField(physicalPos, physicalRow.getField(physicalPos));
        }
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            producedRow.setField(this.fieldCount + metadataPos, this.metadataConverters[metadataPos].convert(rootRow));
        }
        return producedRow;
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxwellJsonDeserializationSchema that = (MaxwellJsonDeserializationSchema)o;
        return Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && this.hasMetadata == that.hasMetadata && Objects.equals(this.producedTypeInfo, that.producedTypeInfo) && this.ignoreParseErrors == that.ignoreParseErrors && this.fieldCount == that.fieldCount;
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.hasMetadata, this.producedTypeInfo, this.ignoreParseErrors, this.fieldCount);
    }

    private static RowType createJsonRowType(DataType physicalDataType, List<MaxwellJsonDecodingFormat.ReadableMetadata> readableMetadata) {
        DataType root = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"data", (DataType)physicalDataType), DataTypes.FIELD((String)FIELD_OLD, (DataType)physicalDataType), DataTypes.FIELD((String)"type", (DataType)DataTypes.STRING())});
        List rootMetadataFields = readableMetadata.stream().map(m -> m.requiredJsonField).distinct().collect(Collectors.toList());
        return (RowType)DataTypeUtils.appendRowFields((DataType)root, rootMetadataFields).getLogicalType();
    }

    private static MetadataConverter[] createMetadataConverters(RowType jsonRowType, List<MaxwellJsonDecodingFormat.ReadableMetadata> requestedMetadata) {
        return (MetadataConverter[])requestedMetadata.stream().map(m -> MaxwellJsonDeserializationSchema.convert(jsonRowType, m)).toArray(MetadataConverter[]::new);
    }

    private static MetadataConverter convert(RowType jsonRowType, final MaxwellJsonDecodingFormat.ReadableMetadata metadata) {
        final int pos = jsonRowType.getFieldNames().indexOf(metadata.requiredJsonField.getName());
        return new MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData root, int unused) {
                return metadata.converter.convert(root, pos);
            }
        };
    }

    static interface MetadataConverter
    extends Serializable {
        default public Object convert(GenericRowData row) {
            return this.convert(row, -1);
        }

        public Object convert(GenericRowData var1, int var2);
    }
}

