/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.agents.api.chat.messages;

/**
 * Enumeration of message roles in a chat conversation. Each role represents a different participant
 * type in the conversation.
 */
public enum MessageRole {

    /** A message from an end-user or developer. */
    USER("user"),

    /** A message generated by the AI assistant in response to user input. */
    ASSISTANT("assistant"),

    /** A system message containing high-level instructions for the conversation. */
    SYSTEM("system"),

    /** A message containing tool or function call results. */
    TOOL("tool");

    private final String value;

    MessageRole(String value) {
        this.value = value;
    }

    public static MessageRole fromValue(String value) {
        for (MessageRole messageRole : MessageRole.values()) {
            if (messageRole.getValue().equals(value)) {
                return messageRole;
            }
        }
        throw new IllegalArgumentException("Invalid MessageRole value: " + value);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value;
    }
}
