/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.agents.api.Agent;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.annotation.ChatModelConnection;
import org.apache.flink.agents.api.annotation.ChatModelSetup;
import org.apache.flink.agents.api.annotation.Prompt;
import org.apache.flink.agents.api.annotation.Tool;
import org.apache.flink.agents.api.resource.Resource;
import org.apache.flink.agents.api.resource.ResourceDescriptor;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.api.resource.SerializableResource;
import org.apache.flink.agents.api.tools.ToolMetadata;
import org.apache.flink.agents.plan.AgentConfiguration;
import org.apache.flink.agents.plan.JavaFunction;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.plan.actions.ChatModelAction;
import org.apache.flink.agents.plan.actions.ToolCallAction;
import org.apache.flink.agents.plan.resourceprovider.JavaResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.JavaSerializableResourceProvider;
import org.apache.flink.agents.plan.resourceprovider.ResourceProvider;
import org.apache.flink.agents.plan.serializer.AgentPlanJsonDeserializer;
import org.apache.flink.agents.plan.serializer.AgentPlanJsonSerializer;
import org.apache.flink.agents.plan.tools.FunctionTool;
import org.apache.flink.agents.plan.tools.ToolMetadataFactory;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=AgentPlanJsonSerializer.class)
@JsonDeserialize(using=AgentPlanJsonDeserializer.class)
public class AgentPlan
implements Serializable {
    private Map<String, Action> actions;
    private Map<String, List<Action>> actionsByEvent;
    private Map<ResourceType, Map<String, ResourceProvider>> resourceProviders;
    private AgentConfiguration config;
    private transient Map<ResourceType, Map<String, Resource>> resourceCache;

    public AgentPlan(Map<String, Action> actions, Map<String, List<Action>> actionsByEvent) {
        this.actions = actions;
        this.actionsByEvent = actionsByEvent;
        this.resourceProviders = new HashMap<ResourceType, Map<String, ResourceProvider>>();
        this.config = new AgentConfiguration();
        this.resourceCache = new ConcurrentHashMap<ResourceType, Map<String, Resource>>();
    }

    public AgentPlan(Map<String, Action> actions, Map<String, List<Action>> actionsByEvent, Map<ResourceType, Map<String, ResourceProvider>> resourceProviders) {
        this.actions = actions;
        this.actionsByEvent = actionsByEvent;
        this.resourceProviders = resourceProviders;
        this.resourceCache = new ConcurrentHashMap<ResourceType, Map<String, Resource>>();
        this.config = new AgentConfiguration();
    }

    public AgentPlan(Map<String, Action> actions, Map<String, List<Action>> actionsByEvent, Map<ResourceType, Map<String, ResourceProvider>> resourceProviders, AgentConfiguration config) {
        this.actions = actions;
        this.actionsByEvent = actionsByEvent;
        this.resourceProviders = resourceProviders;
        this.resourceCache = new ConcurrentHashMap<ResourceType, Map<String, Resource>>();
        this.config = config;
    }

    public AgentPlan(Agent agent) throws Exception {
        this(agent, new AgentConfiguration());
    }

    public AgentPlan(Agent agent, AgentConfiguration config) throws Exception {
        this(new HashMap<String, Action>(), new HashMap<String, List<Action>>());
        this.extractActionsFromAgent(agent);
        this.extractResourceProvidersFromAgent(agent);
        this.config = config;
    }

    public Map<String, Action> getActions() {
        return this.actions;
    }

    public Map<String, Object> getActionConfig(String actionName) {
        return this.actions.get(actionName).getConfig();
    }

    public Object getActionConfigValue(String actionName, String key) {
        return Objects.requireNonNull(this.actions.get(actionName).getConfig()).get(key);
    }

    public Map<String, List<Action>> getActionsByEvent() {
        return this.actionsByEvent;
    }

    public Map<ResourceType, Map<String, ResourceProvider>> getResourceProviders() {
        return this.resourceProviders;
    }

    public List<Action> getActionsTriggeredBy(String eventType) {
        return this.actionsByEvent.get(eventType);
    }

    public Resource getResource(String name, ResourceType type) throws Exception {
        if (this.resourceCache.containsKey((Object)type) && this.resourceCache.get((Object)type).containsKey(name)) {
            return this.resourceCache.get((Object)type).get(name);
        }
        if (!this.resourceProviders.containsKey((Object)type) || !this.resourceProviders.get((Object)type).containsKey(name)) {
            throw new IllegalArgumentException("Resource not found: " + name + " of type " + String.valueOf((Object)type));
        }
        ResourceProvider provider = this.resourceProviders.get((Object)type).get(name);
        Resource resource = provider.provide((anotherName, anotherType) -> {
            try {
                return this.getResource((String)anotherName, (ResourceType)((Object)anotherType));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.resourceCache.computeIfAbsent(type, k -> new ConcurrentHashMap()).put(name, resource);
        return resource;
    }

    public AgentConfiguration getConfig() {
        return this.config;
    }

    public Map<String, Object> getConfigData() {
        return this.config.getConfData();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String serializedStr = new ObjectMapper().writeValueAsString(this);
        out.writeUTF(serializedStr);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String serializedStr = in.readUTF();
        AgentPlan agentPlan = new ObjectMapper().readValue(serializedStr, AgentPlan.class);
        this.actions = agentPlan.getActions();
        this.actionsByEvent = agentPlan.getActionsByEvent();
        this.resourceProviders = agentPlan.getResourceProviders();
        this.config = agentPlan.getConfig();
        this.resourceCache = new ConcurrentHashMap<ResourceType, Map<String, Resource>>();
    }

    private void extractActions(Class<? extends Event>[] listenEventTypes, Method method, Map<String, Object> config) throws Exception {
        ArrayList<String> eventTypeNames = new ArrayList<String>();
        for (Class<? extends Event> eventType : listenEventTypes) {
            eventTypeNames.add(eventType.getName());
        }
        JavaFunction javaFunction = new JavaFunction(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        Action action = new Action(method.getName(), javaFunction, eventTypeNames, config);
        this.actions.put(action.getName(), action);
        for (String eventTypeName : eventTypeNames) {
            this.actionsByEvent.computeIfAbsent(eventTypeName, k -> new ArrayList()).add(action);
        }
    }

    private void addBuiltAction(Action action) {
        this.actions.put(action.getName(), action);
        for (String eventTypeName : action.getListenEventTypes()) {
            this.actionsByEvent.computeIfAbsent(eventTypeName, k -> new ArrayList()).add(action);
        }
    }

    private void extractActionsFromAgent(Agent agent) throws Exception {
        this.addBuiltAction(ChatModelAction.getChatModelAction());
        this.addBuiltAction(ToolCallAction.getToolCallAction());
        Class<?> agentClass = agent.getClass();
        for (Method method : agentClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(org.apache.flink.agents.api.annotation.Action.class)) continue;
            org.apache.flink.agents.api.annotation.Action actionAnnotation = method.getAnnotation(org.apache.flink.agents.api.annotation.Action.class);
            Class<? extends Event>[] listenEventTypes = Objects.requireNonNull(actionAnnotation).listenEvents();
            this.extractActions(listenEventTypes, method, null);
        }
        for (Map.Entry entry : agent.getActions().entrySet()) {
            Tuple3 tuple = (Tuple3)entry.getValue();
            this.extractActions((Class[])tuple.f0, (Method)tuple.f1, (Map)tuple.f2);
        }
    }

    private void extractResource(ResourceType type, Method method) throws Exception {
        String name = method.getName();
        ResourceDescriptor descriptor = (ResourceDescriptor)method.invoke(null, new Object[0]);
        JavaResourceProvider provider = new JavaResourceProvider(name, type, descriptor);
        this.addResourceProvider(provider);
    }

    private void extractTool(Method method) throws Exception {
        String name = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        ToolMetadata metadata = ToolMetadataFactory.fromStaticMethod(method);
        JavaFunction javaFunction = new JavaFunction(method.getDeclaringClass(), method.getName(), paramTypes);
        FunctionTool tool = new FunctionTool(metadata, javaFunction);
        JavaSerializableResourceProvider provider = JavaSerializableResourceProvider.createResourceProvider(name, ResourceType.TOOL, tool);
        this.addResourceProvider(provider);
    }

    private void extractResourceProvidersFromAgent(Agent agent) throws Exception {
        Class<?> agentClass = agent.getClass();
        for (Field field : agentClass.getDeclaredFields()) {
            field.setAccessible(true);
            String errMsg = "Failed to access field " + field.getName() + " in agent class " + agentClass.getName();
            if (field.isAnnotationPresent(Tool.class)) {
                String resourceName = field.getName();
                try {
                    Object fieldValue = field.get(agent);
                    if (fieldValue instanceof Resource) {
                        Resource resource = (Resource)fieldValue;
                        ResourceProvider provider = this.createResourceProvider(resourceName, ResourceType.TOOL, resource, agentClass);
                        this.addResourceProvider(provider);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new Exception(errMsg, e);
                }
            }
            if (!field.isAnnotationPresent(ChatModelSetup.class)) continue;
            ChatModelSetup chatModelAnnotation = field.getAnnotation(ChatModelSetup.class);
            String resourceName = field.getName();
            try {
                Object fieldValue = field.get(agent);
                if (!(fieldValue instanceof Resource)) continue;
                Resource resource = (Resource)fieldValue;
                ResourceProvider provider = this.createResourceProvider(resourceName, ResourceType.CHAT_MODEL, resource, agentClass);
                this.addResourceProvider(provider);
            }
            catch (IllegalAccessException e) {
                throw new Exception(errMsg, e);
            }
        }
        for (AccessibleObject accessibleObject : agentClass.getDeclaredMethods()) {
            if (accessibleObject.isAnnotationPresent(Tool.class) && Modifier.isStatic(((Method)accessibleObject).getModifiers())) {
                this.extractTool((Method)accessibleObject);
                continue;
            }
            if (accessibleObject.isAnnotationPresent(Prompt.class)) {
                String promptName = ((Method)accessibleObject).getName();
                SerializableResource prompt = (SerializableResource)((Method)accessibleObject).invoke(null, new Object[0]);
                JavaSerializableResourceProvider provider = JavaSerializableResourceProvider.createResourceProvider(promptName, ResourceType.PROMPT, prompt);
                this.addResourceProvider(provider);
                continue;
            }
            if (accessibleObject.isAnnotationPresent(ChatModelSetup.class)) {
                this.extractResource(ResourceType.CHAT_MODEL, (Method)accessibleObject);
                continue;
            }
            if (!accessibleObject.isAnnotationPresent(ChatModelConnection.class)) continue;
            this.extractResource(ResourceType.CHAT_MODEL_CONNECTION, (Method)accessibleObject);
        }
        for (Map.Entry entry : agent.getResources().entrySet()) {
            ResourceProvider provider;
            ResourceType type = (ResourceType)((Object)entry.getKey());
            if (type == ResourceType.CHAT_MODEL || type == ResourceType.CHAT_MODEL_CONNECTION) {
                for (Map.Entry kv : ((Map)entry.getValue()).entrySet()) {
                    provider = new JavaResourceProvider((String)kv.getKey(), type, (ResourceDescriptor)kv.getValue());
                    this.addResourceProvider(provider);
                }
                continue;
            }
            if (type == ResourceType.PROMPT) {
                for (Map.Entry kv : ((Map)entry.getValue()).entrySet()) {
                    provider = JavaSerializableResourceProvider.createResourceProvider((String)kv.getKey(), ResourceType.PROMPT, (SerializableResource)kv.getValue());
                    this.addResourceProvider(provider);
                }
                continue;
            }
            if (type != ResourceType.TOOL) continue;
            for (Map.Entry kv : ((Map)entry.getValue()).entrySet()) {
                this.extractTool(((org.apache.flink.agents.api.tools.FunctionTool)kv.getValue()).getMethod());
            }
        }
    }

    private ResourceProvider createResourceProvider(String name, ResourceType type, Resource resource, Class<?> agentClass) throws Exception {
        if (resource instanceof SerializableResource) {
            SerializableResource serializableResource = (SerializableResource)resource;
            return JavaSerializableResourceProvider.createResourceProvider(name, type, serializableResource);
        }
        throw new UnsupportedOperationException("Only support declared SerializableResource as field of Agent.");
    }

    private void addResourceProvider(ResourceProvider provider) {
        this.resourceProviders.computeIfAbsent(provider.getType(), k -> new HashMap()).put(provider.getName(), provider);
    }
}

