/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.agents.plan.Function;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class JavaFunction
implements Function {
    static final String FIELD_NAME_QUAL_NAME = "qualName";
    static final String FIELD_NAME_METHOD_NAME = "methodName";
    static final String FIELD_NAME_PARAMETER_TYPES = "parameterTypes";
    @JsonProperty(value="qualName")
    private final String qualName;
    @JsonProperty(value="methodName")
    private final String methodName;
    @JsonProperty(value="parameterTypes")
    private final Class<?>[] parameterTypes;
    @JsonIgnore
    private transient Method method;

    public JavaFunction(@JsonProperty(value="qualName") String qualName, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="parameterTypes") Class<?>[] parameterTypes) throws Exception {
        this.qualName = qualName;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
    }

    public JavaFunction(Class<?> clazz, String methodName, Class<?>[] parameterTypes) throws Exception {
        this.qualName = clazz.getName();
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.method = clazz.getMethod(methodName, parameterTypes);
    }

    public String getQualName() {
        return this.qualName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
        if (this.method == null) {
            this.method = Class.forName(this.qualName, true, Thread.currentThread().getContextClassLoader()).getMethod(this.methodName, this.parameterTypes);
        }
        return this.method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaFunction that = (JavaFunction)o;
        return Objects.equals(this.qualName, that.qualName) && Objects.equals(this.methodName, that.methodName) && Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        return Objects.hash(this.qualName, this.methodName, Arrays.hashCode(this.parameterTypes));
    }

    @Override
    public Object call(Object ... args) throws Exception {
        return this.getMethod().invoke(null, args);
    }

    @Override
    public void checkSignature(Class<?>[] parameterTypes) {
        String errMsg = String.format("Function \"%s\" expects signature %s, but got %s", this.qualName + "." + this.methodName, Arrays.toString(parameterTypes), Arrays.toString(this.parameterTypes));
        if (this.parameterTypes.length != parameterTypes.length) {
            throw new IllegalArgumentException(errMsg);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(this.parameterTypes[i])) continue;
            throw new IllegalArgumentException(errMsg);
        }
    }
}

